/**
 * 
 */
package org.caiguoqing.salay.server;

import org.caiguoqing.salay.entity.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

/**
 * @author caiguoqing0427
 * 
 */
public class ListenHandler extends ChannelInboundHandlerAdapter {
	private Logger logger = LoggerFactory.getLogger(ListenHandler.class);
	private Context context = Context.getInstance();
	
	/* (non-Javadoc)
	 * @see io.netty.channel.ChannelInboundHandlerAdapter#channelRead(io.netty.channel.ChannelHandlerContext, java.lang.Object)
	 */
	@Override
	public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
		if(msg == null){
			logger.error("msg is null from " + ctx.channel().remoteAddress());
			return;
		}
		try{
			Message message = (Message)msg;
			switch (message.getType()) {
			case Message.PUB:{
				context.pub(message,ctx.channel());
				break;
			}
			case Message.SUB:{
				context.sub(message.getKeys(),ctx.channel());
				break;
			}
			case Message.UNSUB:{
				context.unsub(message.getKeys(),ctx.channel());
				break;
			}
			default:
				logger.error("unknown message " + message.toString());
				break;
			}
			
		}catch (ClassCastException e) {
			logger.error("message cast fail:" + e);
		}
	}

	/* (non-Javadoc)
	 * @see io.netty.channel.ChannelInboundHandlerAdapter#exceptionCaught(io.netty.channel.ChannelHandlerContext, java.lang.Throwable)
	 */
	@Override
	public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
		logger.error(cause.toString());
		super.exceptionCaught(ctx, cause);
	}

}
