/**
 * 
 */
package org.caiguoqing.salay.server;

import org.caiguoqing.salay.entity.Message;
import org.caiguoqing.salay.entity.PublishData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.channel.Channel;

/**
 * @author caiguoqing0427
 * 
 */
public class PublishThread implements Runnable {
	private Context context = Context.getInstance();
	private Logger logger = LoggerFactory.getLogger(PublishThread.class);
	private String name;
	
	public PublishThread(){
		
	}

	public PublishThread(int index){
		this.name = getClass().getSimpleName() + index;
	}
	
	@Override
	public void run() {
		logger.info(name + " run");
		while(true){
			PublishData publish = context.getPub();
			if(publish != null){
				Channel channel = publish.getSocket();
				Message message = publish.getMsg();
				String[] keys = message.getKeys();
				StringBuilder sb = new StringBuilder(keys[0]);
				for(int i = 1; i < keys.length; i ++){
					sb.append(",");
					sb.append(keys[i]);
				}
				logger.info(name + " publish key " + sb.toString() + " to "
					+ channel.remoteAddress());
				channel.writeAndFlush(message);
			}
		}
	}
}
