/**
 * 
 */
package org.caiguoqing.salay.server;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import org.caiguoqing.salay.pub.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;

/**
 * @author caiguoqing0427
 * 
 */
public class Server {
	private Logger logger = LoggerFactory.getLogger(getClass());
	private int port;
	private int threadNum;
	
	public Server(){
		Config config = new Config();
		this.port = config.getPort();
		this.threadNum = config.getPoolSize();
	}
	
	public void run(){
		EventLoopGroup bossGroup = new NioEventLoopGroup();
        EventLoopGroup workerGroup = new NioEventLoopGroup();
        ServerBootstrap boot = new ServerBootstrap();
        boot.group(bossGroup, workerGroup)
			.channel(NioServerSocketChannel.class)
			.childHandler(new AcceptHandler())
            .option(ChannelOption.SO_BACKLOG, 128)          
            .childOption(ChannelOption.SO_KEEPALIVE, true); 

        boot.bind(port);
        logger.info("server bind on port " + port);
        logger.info("server ThreadPool size " + threadNum);
        Executor service = Executors.newFixedThreadPool(threadNum);
        for(int i = 0; i < threadNum; i ++){
        	service.execute(new PublishThread(i));
        }
	}
}
