/**
 * 
 */
package org.caiguoqing.toolbox;

import java.util.ArrayList;
import java.util.List;

/**
 * @author caiguoqing0427
 *
 */
public class ArrayTools {
	public static int min(int a,int b){
		return a > b ? b : a;
	}
	public static int max(int a,int b){
		return a > b ? a : b;
	}
	/**
	 * look up minus and max values
	 * @param arr array
	 * @return {min,max}
	 */
	public static int[] findMaxMin(int[] arr){
		if(arr == null){
			return null;
		}
		if(arr.length == 0){
			return null;
		}
		int max = arr[0];
		int min = arr[0];
		int i = 0;
		for(i = 1; i + 1 < arr.length; i += 2){
			if(arr[i] > arr[i+1]){
				if(arr[i] > max){
					max = arr[i];
				}
				if(arr[i+1] < min){
					min = arr[i+1];
				}
			}else{
				if(arr[i+1] > max){
					max = arr[i+1];
				}
				if(arr[i] < min){
					min = arr[i];
				}
			}
		}
		if(i < arr.length){
			if(arr[i] > max){
				max = arr[i];
			}
			if(arr[i] < min){
				min = arr[i];
			}
		}
		int[] ret = {min,max};
		return ret;
	}
	
	/**
	 * 
	 * @param arr array
	 * @param start start
	 * @param end end
	 */
	public static void reverse(int[] arr,int start,int end){
		if(arr == null){
			return;
		}
		if(arr.length == 0 || start < 0 || end < 0 || start >= arr.length || end >= arr.length){
			return;
		}
		for(; start < end; start ++,end --){
			int temp = arr[start];
			arr[start] = arr[end];
			arr[end] = temp;
		}
	}
	
	/**
	 * 
	 * @param arr array
	 * @param k k
	 */
	public static void shift(int[] arr,int k){
		if(arr == null || k <= 0){
			return;
		}
		if(arr.length == 0){
			return ;
		}
		int n = arr.length;
		k = k % n;
		reverse(arr,n-k,n-1);
		reverse(arr,0,n-k-1);
		reverse(arr,0,n-1);
	}
	
	public static int kMin(int[] arr,int start,int end,int k){
		if(arr == null){
			return Integer.MIN_VALUE;
		}
		if(k > arr.length || k <= 0 || start >= arr.length || start < 0 
				|| end >= arr.length || end < 0 || start > end){
			return Integer.MIN_VALUE;
		}
		
		int i = start;
		int j = end;
		int flag = arr[start];
		
		while(i < j){
			while(i < j && arr[j] >= flag){
				j--;
			}
			if(i < j){
				arr[i++] = arr[j];
			}
			while(i < j && arr[i] <= flag){
				i ++;
			}
			if(i < j){
				arr[j--] = arr[i];
			}
		}
		arr[i] = flag;
		int offset = i - start;
		if(offset == k - 1){
			return flag;
		}else if(offset > k - 1){
			return kMin(arr,start,i-1,k);
		}else{
			return kMin(arr,i+1,end,k - offset - 1);
		}		
	}
	
	/**
	 * look up the single number in an array that others duplicate appearTimes
	 * @param arr array
	 * @param appearTimes appear times
	 * @return single number
	 */
	public static int singleNum(int[] arr,int appearTimes){
		if(arr == null || appearTimes <= 0){
			return Integer.MAX_VALUE;
		}
		if(arr.length == 0){
			return Integer.MAX_VALUE;
		}
		int n = arr.length;
		int[] bitCount = new int[32];
		//loop
		for(int i = 0; i < n; i ++){
			int temp = arr[i];
			for(int j = 0; j < 32; j ++){
				bitCount[j] += (temp>>j) & 0x1;//count numbers of 0b1
			}
		}
		int appear = 0;
		for(int j = 0; j < 32; j ++){
			if(bitCount[j] % appearTimes != 0){
				appear += (0x1 << j);
			}
		}
		
		return appear;
	}
	
	/**
	 * 
	 * @param arr array
	 * @param num1 num1
	 * @param num2 num2
	 * @return distance
	 */
	public static int minDistance(int[] arr,int num1,int num2){
		if(arr == null){
			return Integer.MIN_VALUE;
		}
		if(arr.length == 0){
			return Integer.MAX_VALUE;
		}
		
		int n1Index = -1;
		int n2Index = -1;
		int minDist = Integer.MAX_VALUE;
		for(int i = 0; i < arr.length; i ++){
			if(arr[i] == num1){
				n1Index = i;
				if(n2Index > 0){
					minDist = min(Math.abs(minDist),Math.abs(n1Index - n2Index));
				}
			}
			if(arr[i] == num2){
				n2Index = i;
				if(n1Index > 0){
					minDist = min(Math.abs(minDist),Math.abs(n1Index - n2Index));
				}
			}
		}
		
		return minDist;
	}
	
	/**
	 * 
	 * @param a array a
	 * @param b array b
	 * @return list
	 */
	public static List<Integer> mixset(int[] a,int[] b){
		if(a == null || b == null){
			return null;
		}
		List<Integer> mix = new ArrayList<Integer>();
		int i = 0;
		int j = 0;
		while(i < a.length && j < b.length){
			if(a[i] == b[j]){
				mix.add(a[i]);
				i ++;
				j ++;
			}else if(a[i] < b[j]){
				i ++;
			}else{
				j ++;
			}
		}
		return mix;
	}
	
}
