/**
 * 
 */
package org.caiguoqing.toolbox;

/**
 * @author caiguoqing0427
 *
 */
public class MathTools {
	public static long factorial(int n){
		if(n < 0){
			return 0;
		}
		long ret = 1;
		int i = 1;
		while(i <= n){
			if(ret > Long.MAX_VALUE / i){
				return 0;
			}
			ret *= i;
			i++;
		}
		return ret;
	}
	
	public static long combination(int m,int n){
		if(m <= 0 || n <= 0 || m > n){
			return 0;
		}
		
		return factorial(n)/factorial(m)/factorial(n-m);
	}
	
	public static long combinationSum(int n){
		int m = 1;
		long sum = 0;
		
		while(m <= n){
			sum += combination(m,n);
			m++;
		}
		return sum;
	}
	
	public static boolean isPowerOf(int num1,int num2){
		double d = Math.log(num1) / Math.log(num2);
		double s = d - Math.round(d);
		if(Math.abs(s) < 1e-9){
			return true;
		}
		return false;
	}
	
	public static int countOne(int n){
		int count = 0;
		while(n > 0){
			n = n & (n - 1);//remove one 0b1 in n
			count ++;
		}
		return count;
	}
}
