/**
 * 
 */
package org.caiguoqing.toolbox.sort;

import org.caiguoqing.toolbox.pub.Compare;
import org.caiguoqing.toolbox.pub.CompareHandle;

/**
 * @author caiguoqing0427
 *
 */
public class HeapSort<T> extends Compare {

	public HeapSort(CompareHandle handle) {
		super(handle);
	}
	
	public HeapSort() {
		super(null);
	}
	
	private void ajustMin(T[] arr,int pos,int len){
		for(int child = 2 * pos + 1; child <= len; pos = child,child = 2 * child + 1){
			if(child < len && compare(arr[child],arr[child+1]) > 0){
				child ++;
			}
			if(compare(arr[child],arr[pos]) < 0){
				T temp = arr[pos];
				arr[pos] = arr[child];
				arr[child] = temp;
			}else{
				break;//not continue
			}
		}
	}
	
	private void ajustMax(T[] arr,int pos,int len){
		for(int child = 2*pos+1; child<=len;pos=child,child = 2*child+1){
			if(child < len && compare(arr[child],arr[child+1]) < 0){
				child ++;
			}
			if(compare(arr[child],arr[pos]) > 0){
				T temp = arr[pos];
				arr[pos] = arr[child];
				arr[child] = temp;
			}else{
				break;//not continue
			}
		}
	}
	
	public void sortMax(T[] arr){
		if(arr == null){
			return;
		}
		for(int i = (arr.length) / 2 - 1; i >= 0; i --){
			ajustMax(arr,i,arr.length-1);
		}
		for(int i = arr.length - 1; i >= 0; i --){
			T temp = arr[0];
			arr[0] = arr[i];
			arr[i] = temp;
			ajustMax(arr,0,i - 1);
		}
	}
	
	public void sortMin(T[] arr){
		if(arr == null){
			return;
		}
		for(int i = (arr.length) / 2 - 1; i >= 0; i --){
			ajustMin(arr,i,arr.length-1);
		}
		for(int i = arr.length - 1; i >= 0; i --){
			T temp = arr[0];
			arr[0] = arr[i];
			arr[i] = temp;
			ajustMin(arr,0,i - 1);
		}
	}
}
