/**
 * 
 */
package org.caiguoqing.toolbox.sort;

import org.caiguoqing.toolbox.pub.Compare;
import org.caiguoqing.toolbox.pub.CompareHandle;

/**
 * @author caiguoqing0427
 *
 */
public class MergeSort<T> extends Compare {
	public MergeSort(CompareHandle handle){
		super(handle);
	}
	
	public MergeSort(){
		super(null);
	}
	
	private void merge(T[] arr,int start,int mid,int end){
		int n1 = mid - start + 1;
		int n2 = end - mid;
		@SuppressWarnings("unchecked")
		T[] L = (T[])new Object[n1];
		@SuppressWarnings("unchecked")
		T[] R = (T[])new Object[n2];
		for(int i = 0; i < n1; i ++){
			L[i] = arr[i + start];
		}
		for(int i = 0; i < n2; i ++){
			R[i] = arr[i + mid + 1];
		}
		int i = 0;
		int j = 0;
		int k = start;
		for(; i < n1 && j < n2; k ++){
			if(compare(L[i],R[j]) < 0){
				arr[k] = L[i];
				i ++;
			}else{
				arr[k] = R[j];
				j ++;
			}
		}
		if(i < n1){
			for(int t = i; t < n1; t ++,k ++){
				arr[k] = L[t];
			}
		}
		if(j < n2){
			for(int t = j; t < n2; t ++,k ++){
				arr[k] = R[t];
			}
		}
	}
	
	public void sort(T[] arr,int start,int end){
		if(arr == null){
			return;
		}
		int len = arr.length;
		if(start < 0 || start >= len || end < 0 || end >= len || start >= end){
			return;
		}
		int mid = (start + end)/2;
		sort(arr,start,mid);
		sort(arr,mid+1,end);
		merge(arr,start,mid,end);
	}
}
