/**
 * 
 */
package org.caiguoqing.toolbox.structure;

/**
 * @author caiguoqing0427
 *
 */
public class LinkedList<T> {
	private Node head;
	private Node tail;
	private int length;
	
	private class Node{
		T value;
		Node prev;
		Node next;
		
		public Node(T value){
			this.value = value;
		}
	}
	
	public LinkedList(){
		
	}
	
	public void add(T value){
		Node node = new Node(value);
		if(tail == null || head == null){
			head = node;
			tail = node;
		} else {
			tail.next = node;
			node.prev = tail;
			tail = node;
		}
		length ++;		
	}
	
	public void addFirst(T value){
		Node node = new Node(value);
		if(tail == null || head == null){
			head = node;
			tail = node;
		}else{
			head.prev = node;
			node.next = head;
			head = node;
		}
		length ++;
	}
	
	public void addLast(T value){
		add(value);
	}
	
	private T remove(Node node){
		if(node == null || head == null || tail == null){
			return null;
		}
		/*only one element*/
		if(head == tail){
			if(node == head){
				length = 0;
				head = null;
				tail = null;
				return node.value;
			}
			return null;
		}
		
		if(node == head){
			head = head.next;
		}else if(node == tail){
			tail = tail.prev;
			tail.next = null;
		}else{
			node.prev.next = node.next;
		}
		length --;
		return node.value;
	}
	
	public T remove(T value){
		Node node = head;
		while(node != null){
			if(node.value.equals(value)){
				return remove(node);
			}
			node = node.next;
		}
		return null;
	}
	
	private T removeFront(int index){
		Node node = head;
		while(node != null){
			if(index-- <= 0){
				return remove(node);
			}
			node = node.next;
		}
		return null;
	}
	
	private T removeBack(int index){
		Node node = tail;
		while(node != null){
			if(index-- <= 0){
				return remove(node);
			}
			node = node.prev;
		}
		return null;
	}
	
	public T remove(int index){
		int abs = (index >= 0) ? index : (-index);
		if(index >= length || (length + index) < 0){
			return null;
		}
		
		if(index >= 0){
			if(2 * abs <= length){
				return removeFront(abs);
			}else{
				return removeBack(length - abs - 1);
			}
		}else{
			if(2 * abs <= length){
				return removeBack(abs - 1);
			}else{
				return removeFront(length - abs);
			}
		}
	}
	
	public T remove(){
		return remove(0);
	}
	
	public T removeFisrt(){
		return remove(0);
	}
	
	public T removeLast(){
		return remove(-1);
	}
	
	private T getFront(int index){
		Node node = head;
		while(node != null){
			if(index-- <= 0){
				return node.value;
			}
			node = node.next;
		}
		
		return null;
	}
	
	private T getBack(int index){
		Node node = tail;
		while(node != null){
			if(index-- <= 0){
				return node.value;
			}
			node = node.prev;
		}
		
		return null;
	}
	
	public T get(int index){
		int abs = (index >= 0) ? index : (-index);
		if(index >= length || (length + index) < 0){
			return null;
		}
		
		if(index >= 0){
			if(2 * abs <= length){
				return getFront(abs);
			}else{
				return getBack(length - abs - 1);
			}
		}else{
			if(2 * abs <= length){
				return getBack(abs - 1);
			}else{
				return getFront(length - abs);
			}
		}
	}
	
	public T peek(){
		if(head == null){
			return null;
		}else{
			return head.value;
		}
	}
	
	public T poll(){
		T value = peek();
		if(value != null){
			remove();
		}
		return value;
	}
	
	public T getLast(){
		if(tail == null){
			return null;
		}else{
			return tail.value;
		}
	}
	
	public int size(){
		return length;
	}
}
