/**
 * 
 */
package org.caiguoqing.toolbox.structure;

import java.util.HashMap;
import java.util.Map;

/**
 * @author caiguoqing0427
 *
 */
public class SingleLinkedList<T> {
	private Node head;
	private int length;
	
	public class Node{
		public T value;
		public Node next;
		
		public Node(T value){
			this.value = value;
			next = null;
		}
	}
	
	public Node getHeader(){
		return head;
	}
	
	/**
	 * add one element
	 * @param value value
	 */
	public void add(T value){
		Node node = new Node(value);
		addNode(node);
	}
	
	/**
	 * add one node
	 * @param node node
	 */
	public void addNode(Node node){
		if(head == null){
			head = node;
			length = 1;
			return;
		}
		Node pointer = head;
		while(pointer.next != null){
			pointer = pointer.next;
		}
		pointer.next = node;
		length ++;
	}
	
	/**
	 * get one element
	 * @param index index
	 * @return value value
	 */
	public T get(int index){
		Node node = getNode(index);
		if(node != null){
			return node.value;
		}else{
			return null;
		}
	}
	
	/**
	 * get one node
	 * @param index index
	 * @return node node
	 */
	public Node getNode(int index){
		if(index < 0 || index >= length){
			return null;
		}
		Node node = head;
		while(node != null){
			if(index-- <= 0){
				return node;
			}
			node = node.next;
		}
		return null;
	}
	
	/**
	 * set one element
	 * @param index index
	 * @param value value
	 * @return if success
	 */
	public boolean set(int index,T value){
		if(index < 0 || index >= length){
			return false;
		}
		Node node = head;
		while(node != null){
			if(index-- <= 0){
				node.value = value;
				return true;
			}
			node = node.next;
		}
		return false;
	}
	
	/**
	 * delete one element
	 * @param index index
	 * @return if success
	 */
	public boolean delete(int index){
		if(index < 0 || index >= length){
			return false;
		}
		Node node = head;
		if(index == 0){
			head = head.next;
			length --;
			return true;
		}else{
			while(node.next != null){
				if(index-- <= 1){
					node.next = node.next.next;
					length --;
					return true;
				}
				node = node.next;
			}
		}
		
		return false;
	}
	
	/**
	 * get size of list
	 * @return size
	 */
	public int size(){
		if(length < 0){
			length = 0;
		}
		return length;
	}
	
	/**
	 * print the list
	 */
	public void print(){
		Node node = head;
		System.out.print("[");
		if(head != null){
			System.out.print(head.value);
			node = head.next;
		}
		while(node != null){
			System.out.print("," + node.value);
			node = node.next;
		}
		System.out.println("]");
	}
	
	/**
	 * print the list backward
	 */
	public void printBackward(){
		System.out.print("[");
		printBackward(head);
		System.out.println("]");
	}
	
	private void printBackward(Node node){
		if(node == null){
			return;
		}
		printBackward(node.next);
		if(node == head){
			System.out.print(node.value);
		}else{
			System.out.print(node.value + ",");
		}
	}
	
	/**
	 * Delete duplicate elements without extra memory but more time
	 */
	public void deleteDuplicate(){
		Node cur = head;
		Node now;
		while(cur != null){
			now = cur;
			while(now.next != null){
				if(now.next.value.equals(cur.value)){
					now.next = now.next.next;
					length --;
				}else{
					now = now.next;
				}
			}
			cur = cur.next;
		}
	}
	
	/**
	 * Delete duplicate elements using HashMap
	 */
	public void hashDeleteDuplicate(){
		Map<T,Integer> map = new HashMap<T,Integer>();
		Node node = head;
		Node prev = head;
		while(node != null){
			if(map.containsKey(node.value)){
				prev.next = node.next;
				length --;
			}else{
				prev = node;
				map.put(node.value, 1);
			}
			node = node.next;
		}
	}
	
	/**
	 * count backwards
	 * @param k k
	 * @return value
	 */
	public T findBackwardElement(int k){
		if(k <= 0 || k > length){
			return null;
		}
		Node prev = head;
		while(prev != null){
			if(k-- <= 1){
				break;
			}
			prev = prev.next;
		}
		Node node = head;
		while(prev.next != null){
			prev = prev.next;
			node = node.next;
		}
		
		return node.value;
	}
	
	/**
	 * reverse the list and return a new list
	 * @return new list
	 */
	public SingleLinkedList<T> reverse(){
		Stack<T> stack = new Stack<T>();
		Node node = head;
		while(node != null){
			stack.push(node.value);
			node = node.next;
		}
		SingleLinkedList<T> list = new SingleLinkedList<T>();
		while(!stack.empty()){
			list.add(stack.pop());
		}
		
		return list;
	}
	
	/**
	 * reverse the list itself
	 */
	public void reverseSelf(){
		if(head == null){
			return;
		}
		Node node = head;
		Node prev = null;
		Node next = null;
		Node headNew = head;
		while(node != null){
			next = node.next;
			if(next == null){
				headNew = node;
			}
			node.next = prev;
			prev = node;
			node = next;
		}
		head = headNew;
	}
	
	/**
	 * middle element n/2
	 * @return value
	 */
	public T getMiddleElement(){
		Node node = head;
		Node ret = head;
		/*          n/2         */
		while(node != null && node.next != null && node.next.next != null){
			node = node.next.next;
			ret = ret.next;
		}
		return ret.value;
	}
	
	/**
	 * 
	 * @return if loop
	 */
	public boolean isLoop(){
		Node fast = head;
		Node slow = head;
		
		while(fast != null && fast.next != null){
			fast = fast.next.next;
			slow = slow.next;
			if(fast == slow){
				return true;
			}
		}
		return false;
	}
	
	public boolean isMeetWith(SingleLinkedList<T> list){
		if(list == null){
			return false;
		}
		if(head == null || list.getHeader() == null){
			return false;
		}
		Node node1 = head;
		while(node1.next != null){
			node1 = node1.next;
		}
		Node node2 = list.getHeader();
		while(node2.next != null){
			node2 = node2.next;
		}
		return (node1 == node2);
	}
	
	public Node meetNode(SingleLinkedList<T> list){
		if(list == null){
			return null;
		}
		if(head == null || list.getHeader() == null){
			return null;
		}
		int d1 = 0;
		int d2 = 0;
		Node node1 = head;
		Node node2 = list.getHeader();
		System.out.println("debug2");
		while(node1.next != null){
			System.out.println("" + d1 + " " + node1.value);
			node1 = node1.next;
			d1 ++;
		}System.out.println("debug3");
		while(node2.next != null){
			node2 = node2.next;
			d2 ++;
		}
		if(node1 != node2){
			return null;
		}
		node1 = head;
		node2 = list.getHeader();
		System.out.println("debug");
		if(d1 > d2){
			while(d1-- > d2){
				node1 = node1.next;
			}
		}else{
			while(d2-- > d1){
				node2 = node2.next;
			}
		}
		while(node1 != node2){
			node1 = node1.next;
			node2 = node2.next;
		}
		return node1;
	}
}
