/**
 * 
 */
package org.caiguoqing.toolbox.structure.graph;

import java.util.Stack;

/**
 * @author caiguoqing0427
 *
 */
public class MatrixGraph{
	private int[] nodes;
	private int[][] weights;
	private int length;
	private int max;
	private boolean direct;
	
	public MatrixGraph(int n,boolean direct){
		nodes = new int[n];
		weights = new int[n][n];
		length = 0;
		max = n;
		this.direct = direct;
	}
	
	public MatrixGraph(int n){
		this(n,false);
	}
	
	public boolean addNode(int node){
		if(length < max){
			nodes[length++] = node;
			return true;
		}else{
			return false;
		}
	}
	
	public boolean addWeight(int from,int to,int weight){
		if(from < 0 || to < 0 || from >= length || to >= length || from == to){
			return false;
		}
		weights[from][to] = weight;
		if(!direct){
			weights[to][from] = weight;
		}
		return true;
	}
	
	public void show(){
		System.out.print("nodes :");
		for(int i = 0; i < length; i ++){
			System.out.print(" " + nodes[i]);
		}
		System.out.println("");
		
		System.out.println("weights :");
		for(int i = 0; i < length; i ++){
			for(int j = 0; j < length; j ++){
				System.out.print(" " + weights[i][j]);
			}
			System.out.println("");
		}
	}
	
	public void deepVisit(){
		final boolean[] visited = new boolean[length];
		
		class DeepMethod{
			public void run(int i){
				visited[i] = true;
				System.out.print(" " + nodes[i]);
				for(int j = 0; j < length; j ++){
					if(!visited[j] && weights[i][j] != 0){
						run(j);
					}
				}
			}
		}
		
		DeepMethod method = new DeepMethod();
		System.out.print("deepVisit:");
		for(int i = 0; i < length; i ++){
			if(!visited[i]){
				method.run(i);
			}
		}
		System.out.println("");
	}
	
	public void breadVisit(){
		boolean[] visited = new boolean[length];
		Stack<Integer> stack = new Stack<Integer>();
		
		System.out.print("breadVisit:");
		for(int i = 0; i < length; i ++){
			if(!visited[i]){
				visited[i] = true;
				stack.push(i);
				System.out.print(" " + nodes[i]);
				while(!stack.empty()){
					int index = stack.pop();
					for(int j = 0; j < length; j ++){
						if(!visited[j] && weights[index][j] != 0){
							visited[j] = true;
							stack.push(j);
							System.out.print(" " + nodes[j]);
						}
					}
				}
			}
		}
		System.out.println("");
	}
	
	public void primMinTree(){
		int[] adjvex = new int[length];
		int[] lowCost = new int[length];
		
		System.out.print("primMinTree:");
		adjvex[0] = 0;//put it in min tree
		lowCost[0] = 0;//put it in min tree
		for(int i = 1; i < length; i ++){
			if(weights[0][i] == 0){
				lowCost[i] = Integer.MAX_VALUE;
			}else{
				lowCost[i] = weights[0][i];//first line
			}
			adjvex[i] = 0;
		}
		int k = 0;
		int j = 1;
		for(int i = 1; i < length; i ++){
			int min = Integer.MAX_VALUE;
			j = 1;
			k = 0;
			while(j < length){
				if(lowCost[j] != 0 && lowCost[j] < min){
					min = lowCost[j];
					k = j;
				}
				j ++;
			}
			System.out.print(" (" + adjvex[k] + "," + k + ")");//one
			lowCost[k] = 0;//put it in min tree
			for(j = 1; j < length; j ++){
				if(lowCost[j] != 0 && weights[k][j] != 0 && weights[k][j] < lowCost[j]){
					lowCost[j] = weights[k][j];
					adjvex[j] = k;
				}
			}
		}
		System.out.println("");
	}
}
