/**
 * 
 */
package org.caiguoqing.toolbox.structure.tree;

import org.caiguoqing.toolbox.pub.CompareHandle;

/**
 * @author caiguoqing0427
 *
 */
public class BinarySearchTree<T> extends BinaryTree<T> {
	
	public BinarySearchTree(T value){
		super(value);
	}
	
	public BinarySearchTree(T value,CompareHandle handle){
		super(value,handle);
	}
	
	public BinaryNode<T> add(T value){
		BinaryNode<T> node = new BinaryNode<T>(value);
		BinaryNode<T> x = getRoot();
		BinaryNode<T> pointer = x;
		
		while(x != null){
			pointer = x;
			if(compare(x.value,value) <= 0){
				x = x.right;
			}else{
				x = x.left;
			}
		}
		if(compare(pointer.value,value) <= 0){
			pointer.right = node;
		}else{
			pointer.left = node;
		}
		
		return node;
	}
	
	public BinaryNode<T> get(BinaryNode<T> root,T value){
		if(root == null || value == null){
			return null;
		}
		if(value.equals(root.value)){
			return root;
		}else if(compare(value,root.value) < 0){
			return get(root.left,value);
		}else{
			return get(root.right,value);
		}
	}
	
	public BinaryNode<T> get(T value){
		if(getRoot() == null || value == null){
			return null;
		}
		return get(getRoot(),value);
	}
	
	private boolean delete(BinaryNode<T> node){
		if(node == null){
			return false;
		}
		if(node.left == null){
			BinaryNode<T> temp = node.right;
			node.value = temp.value;
			node.left = temp.left;
			node.right = temp.right;
		}else if(node.right == null){
			BinaryNode<T> temp = node.left;
			node.value = temp.value;
			node.right = temp.right;
			node.left = temp.left;
		}else{
			BinaryNode<T> q = node;
			BinaryNode<T> s = node.left;
			while(s.right != null){
				q = s;
				s = s.right;
			}
			node.value = s.value;
			if(q != node){
				q.right = s.left;
			}else{
				q.left = s.left;
			}
		}
		return true;
	}
	
	public boolean remove(BinaryNode<T> root,T value){
		if(root == null || value == null){
			return false;
		}
		if(value.equals(root.value)){
			return delete(root);
		}else if(compare(value,root.value) < 0){
			return remove(root.left,value);
		}else{
			return remove(root.right,value);
		}
	}
	
	public boolean remove(T value){
		if(getRoot() == null || value == null){
			return false;
		}
		return remove(getRoot(),value);
	}
}
