/**
 * 
 */
package org.caiguoqing.toolbox.structure.tree;

import org.caiguoqing.toolbox.pub.Compare;
import org.caiguoqing.toolbox.pub.CompareHandle;
import org.caiguoqing.toolbox.structure.LinkedList;

/**
 * @author caiguoqing0427
 *
 */
public class BinaryTree<T> extends Compare {
	private BinaryNode<T> root;
	
	public BinaryTree(T value,CompareHandle handle){
		super(handle);
		root = new BinaryNode<T>(value);
	}
	
	public BinaryTree(T value){
		super(null);
		root = new BinaryNode<T>(value);
	}
	
	public BinaryNode<T> getRoot(){
		return root;
	}
	
	public void setRoot(BinaryNode<T> root){
		this.root = root;
	}
	
	private void frontLoopDo(BinaryNode<T> node,LinkedList<T> list){
		if(node == null || list == null){
			return;
		}
		list.add(node.value);
		frontLoopDo(node.left,list);
		frontLoopDo(node.right,list);
	}
	
	private void middleLoopDo(BinaryNode<T> node,LinkedList<T> list){
		if(node == null || list == null){
			return;
		}
		middleLoopDo(node.left,list);
		list.add(node.value);
		middleLoopDo(node.right,list);
	}
	
	private void backLoopDo(BinaryNode<T> node,LinkedList<T> list){
		if(node == null || list == null){
			return;
		}
		backLoopDo(node.left,list);
		backLoopDo(node.right,list);
		list.add(node.value);
	}
	
	public LinkedList<T> frontLoop(){
		LinkedList<T> list = new LinkedList<T>();
		frontLoopDo(root,list);
		return list;
	}
	
	public LinkedList<T> middleLoop(){
		LinkedList<T> list = new LinkedList<T>();
		middleLoopDo(root,list);
		return list;
	}
	
	public LinkedList<T> backLoop(){
		LinkedList<T> list = new LinkedList<T>();
		backLoopDo(root,list);
		return list;
	}
}
