/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.toolbox;

import java.util.ArrayList;
import java.util.List;

public class ArrayTools {
    public static int min(int a, int b) {
        return a > b ? b : a;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static int[] findMaxMin(int[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return null;
        }
        int max = arr[0];
        int min = arr[0];
        int i = 0;
        i = 1;
        while (i + 1 < arr.length) {
            if (arr[i] > arr[i + 1]) {
                if (arr[i] > max) {
                    max = arr[i];
                }
                if (arr[i + 1] < min) {
                    min = arr[i + 1];
                }
            } else {
                if (arr[i + 1] > max) {
                    max = arr[i + 1];
                }
                if (arr[i] < min) {
                    min = arr[i];
                }
            }
            i += 2;
        }
        if (i < arr.length) {
            if (arr[i] > max) {
                max = arr[i];
            }
            if (arr[i] < min) {
                min = arr[i];
            }
        }
        int[] ret = new int[]{min, max};
        return ret;
    }

    public static void reverse(int[] arr, int start, int end) {
        if (arr == null) {
            return;
        }
        if (arr.length == 0 || start < 0 || end < 0 || start >= arr.length || end >= arr.length) {
            return;
        }
        while (start < end) {
            int temp = arr[start];
            arr[start] = arr[end];
            arr[end] = temp;
            ++start;
            --end;
        }
    }

    public static void shift(int[] arr, int k) {
        if (arr == null || k <= 0) {
            return;
        }
        if (arr.length == 0) {
            return;
        }
        int n = arr.length;
        ArrayTools.reverse(arr, n - (k %= n), n - 1);
        ArrayTools.reverse(arr, 0, n - k - 1);
        ArrayTools.reverse(arr, 0, n - 1);
    }

    public static int kMin(int[] arr, int start, int end, int k) {
        if (arr == null) {
            return Integer.MIN_VALUE;
        }
        if (k > arr.length || k <= 0 || start >= arr.length || start < 0 || end >= arr.length || end < 0 || start > end) {
            return Integer.MIN_VALUE;
        }
        int i = start;
        int j = end;
        int flag = arr[start];
        while (i < j) {
            while (i < j && arr[j] >= flag) {
                --j;
            }
            if (i < j) {
                arr[i++] = arr[j];
            }
            while (i < j && arr[i] <= flag) {
                ++i;
            }
            if (i >= j) continue;
            arr[j--] = arr[i];
        }
        arr[i] = flag;
        int offset = i - start;
        if (offset == k - 1) {
            return flag;
        }
        if (offset > k - 1) {
            return ArrayTools.kMin(arr, start, i - 1, k);
        }
        return ArrayTools.kMin(arr, i + 1, end, k - offset - 1);
    }

    public static int singleNum(int[] arr, int appearTimes) {
        if (arr == null || appearTimes <= 0) {
            return Integer.MAX_VALUE;
        }
        if (arr.length == 0) {
            return Integer.MAX_VALUE;
        }
        int n = arr.length;
        int[] bitCount = new int[32];
        for (int i = 0; i < n; ++i) {
            int temp = arr[i];
            for (int j = 0; j < 32; ++j) {
                int n2 = j;
                bitCount[n2] = bitCount[n2] + (temp >> j & 1);
            }
        }
        int appear = 0;
        for (int j = 0; j < 32; ++j) {
            if (bitCount[j] % appearTimes == 0) continue;
            appear += 1 << j;
        }
        return appear;
    }

    public static int minDistance(int[] arr, int num1, int num2) {
        if (arr == null) {
            return Integer.MIN_VALUE;
        }
        if (arr.length == 0) {
            return Integer.MAX_VALUE;
        }
        int n1Index = -1;
        int n2Index = -1;
        int minDist = Integer.MAX_VALUE;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == num1) {
                n1Index = i;
                if (n2Index > 0) {
                    minDist = ArrayTools.min(Math.abs(minDist), Math.abs(n1Index - n2Index));
                }
            }
            if (arr[i] != num2) continue;
            n2Index = i;
            if (n1Index <= 0) continue;
            minDist = ArrayTools.min(Math.abs(minDist), Math.abs(n1Index - n2Index));
        }
        return minDist;
    }

    public static List<Integer> mixset(int[] a, int[] b) {
        if (a == null || b == null) {
            return null;
        }
        ArrayList<Integer> mix = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < a.length && j < b.length) {
            if (a[i] == b[j]) {
                mix.add(a[i]);
                ++i;
                ++j;
                continue;
            }
            if (a[i] < b[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return mix;
    }
}

