/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.toolbox.sort;

import org.caiguoqing.toolbox.pub.Compare;
import org.caiguoqing.toolbox.pub.CompareHandle;

public class QuickSort<T>
extends Compare {
    public QuickSort(CompareHandle handle) {
        super(handle);
    }

    public QuickSort() {
        super(null);
    }

    private int partition(T[] arr, int start, int end) {
        int mid = (int)(Math.random() * (double)(end - start)) + start;
        T temp = arr[mid];
        arr[mid] = arr[start];
        arr[start] = temp;
        mid = start;
        int i = start;
        int j = end;
        while (i < j) {
            while (i < j && this.compare(arr[j], temp) >= 0) {
                --j;
            }
            if (i < j) {
                arr[i++] = arr[j];
            }
            while (i < j && this.compare(arr[i], temp) <= 0) {
                ++i;
            }
            if (i >= j) continue;
            arr[j--] = arr[i];
        }
        arr[i] = temp;
        return i;
    }

    public void sort(T[] arr, int start, int end) {
        if (arr == null) {
            return;
        }
        if (start < 0 || end < 0 || start >= arr.length || end >= arr.length || start >= end) {
            return;
        }
        int mid = this.partition(arr, start, end);
        this.sort(arr, start, mid - 1);
        this.sort(arr, mid + 1, end);
    }
}

