/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.toolbox.structure;

public class LinkedList<T> {
    private Node head;
    private Node tail;
    private int length;

    public void add(T value) {
        Node node = new Node(value);
        if (this.tail == null || this.head == null) {
            this.head = node;
            this.tail = node;
        } else {
            this.tail.next = node;
            node.prev = this.tail;
            this.tail = node;
        }
        ++this.length;
    }

    public void addFirst(T value) {
        Node node = new Node(value);
        if (this.tail == null || this.head == null) {
            this.head = node;
            this.tail = node;
        } else {
            this.head.prev = node;
            node.next = this.head;
            this.head = node;
        }
        ++this.length;
    }

    public void addLast(T value) {
        this.add(value);
    }

    private T remove(Node node) {
        if (node == null || this.head == null || this.tail == null) {
            return null;
        }
        if (this.head == this.tail) {
            if (node == this.head) {
                this.length = 0;
                this.head = null;
                this.tail = null;
                return node.value;
            }
            return null;
        }
        if (node == this.head) {
            this.head = this.head.next;
        } else if (node == this.tail) {
            this.tail = this.tail.prev;
            this.tail.next = null;
        } else {
            node.prev.next = node.next;
        }
        --this.length;
        return node.value;
    }

    public T remove(T value) {
        Node node = this.head;
        while (node != null) {
            if (node.value.equals(value)) {
                return (T)this.remove((T)node);
            }
            node = node.next;
        }
        return null;
    }

    private T removeFront(int index) {
        Node node = this.head;
        while (node != null) {
            if (index-- <= 0) {
                return (T)this.remove((T)node);
            }
            node = node.next;
        }
        return null;
    }

    private T removeBack(int index) {
        Node node = this.tail;
        while (node != null) {
            if (index-- <= 0) {
                return (T)this.remove((T)node);
            }
            node = node.prev;
        }
        return null;
    }

    public T remove(int index) {
        int abs;
        int n = abs = index >= 0 ? index : -index;
        if (index >= this.length || this.length + index < 0) {
            return null;
        }
        if (index >= 0) {
            if (2 * abs <= this.length) {
                return this.removeFront(abs);
            }
            return this.removeBack(this.length - abs - 1);
        }
        if (2 * abs <= this.length) {
            return this.removeBack(abs - 1);
        }
        return this.removeFront(this.length - abs);
    }

    public T remove() {
        return this.remove(0);
    }

    public T removeFisrt() {
        return this.remove(0);
    }

    public T removeLast() {
        return this.remove(-1);
    }

    private T getFront(int index) {
        Node node = this.head;
        while (node != null) {
            if (index-- <= 0) {
                return node.value;
            }
            node = node.next;
        }
        return null;
    }

    private T getBack(int index) {
        Node node = this.tail;
        while (node != null) {
            if (index-- <= 0) {
                return node.value;
            }
            node = node.prev;
        }
        return null;
    }

    public T get(int index) {
        int abs;
        int n = abs = index >= 0 ? index : -index;
        if (index >= this.length || this.length + index < 0) {
            return null;
        }
        if (index >= 0) {
            if (2 * abs <= this.length) {
                return this.getFront(abs);
            }
            return this.getBack(this.length - abs - 1);
        }
        if (2 * abs <= this.length) {
            return this.getBack(abs - 1);
        }
        return this.getFront(this.length - abs);
    }

    public T peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.value;
    }

    public T poll() {
        T value = this.peek();
        if (value != null) {
            this.remove();
        }
        return value;
    }

    public T getLast() {
        if (this.tail == null) {
            return null;
        }
        return this.tail.value;
    }

    public int size() {
        return this.length;
    }

    private class Node {
        T value;
        Node prev;
        Node next;

        public Node(T value) {
            this.value = value;
        }
    }
}

