/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.toolbox.structure;

import java.util.HashMap;
import org.caiguoqing.toolbox.structure.Stack;

public class SingleLinkedList<T> {
    private Node head;
    private int length;

    public Node getHeader() {
        return this.head;
    }

    public void add(T value) {
        Node node = new Node(value);
        this.addNode(node);
    }

    public void addNode(Node node) {
        if (this.head == null) {
            this.head = node;
            this.length = 1;
            return;
        }
        Node pointer = this.head;
        while (pointer.next != null) {
            pointer = pointer.next;
        }
        pointer.next = node;
        ++this.length;
    }

    public T get(int index) {
        Node node = this.getNode(index);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    public Node getNode(int index) {
        if (index < 0 || index >= this.length) {
            return null;
        }
        Node node = this.head;
        while (node != null) {
            if (index-- <= 0) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    public boolean set(int index, T value) {
        if (index < 0 || index >= this.length) {
            return false;
        }
        Node node = this.head;
        while (node != null) {
            if (index-- <= 0) {
                node.value = value;
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public boolean delete(int index) {
        if (index < 0 || index >= this.length) {
            return false;
        }
        Node node = this.head;
        if (index == 0) {
            this.head = this.head.next;
            --this.length;
            return true;
        }
        while (node.next != null) {
            if (index-- <= 1) {
                node.next = node.next.next;
                --this.length;
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public int size() {
        if (this.length < 0) {
            this.length = 0;
        }
        return this.length;
    }

    public void print() {
        Node node = this.head;
        System.out.print("[");
        if (this.head != null) {
            System.out.print(this.head.value);
            node = this.head.next;
        }
        while (node != null) {
            System.out.print("," + node.value);
            node = node.next;
        }
        System.out.println("]");
    }

    public void printBackward() {
        System.out.print("[");
        this.printBackward(this.head);
        System.out.println("]");
    }

    private void printBackward(Node node) {
        if (node == null) {
            return;
        }
        this.printBackward(node.next);
        if (node == this.head) {
            System.out.print(node.value);
        } else {
            System.out.print(node.value + ",");
        }
    }

    public void deleteDuplicate() {
        Node cur = this.head;
        while (cur != null) {
            Node now = cur;
            while (now.next != null) {
                if (now.next.value.equals(cur.value)) {
                    now.next = now.next.next;
                    --this.length;
                    continue;
                }
                now = now.next;
            }
            cur = cur.next;
        }
    }

    public void hashDeleteDuplicate() {
        HashMap map = new HashMap();
        Node node = this.head;
        Node prev = this.head;
        while (node != null) {
            if (map.containsKey(node.value)) {
                prev.next = node.next;
                --this.length;
            } else {
                prev = node;
                map.put(node.value, 1);
            }
            node = node.next;
        }
    }

    public T findBackwardElement(int k) {
        if (k <= 0 || k > this.length) {
            return null;
        }
        Node prev = this.head;
        while (prev != null && k-- > 1) {
            prev = prev.next;
        }
        Node node = this.head;
        while (prev.next != null) {
            prev = prev.next;
            node = node.next;
        }
        return node.value;
    }

    public SingleLinkedList<T> reverse() {
        Stack stack = new Stack();
        Node node = this.head;
        while (node != null) {
            stack.push(node.value);
            node = node.next;
        }
        SingleLinkedList list = new SingleLinkedList();
        while (!stack.empty()) {
            list.add(stack.pop());
        }
        return list;
    }

    public void reverseSelf() {
        if (this.head == null) {
            return;
        }
        Node node = this.head;
        Node prev = null;
        Node next = null;
        Node headNew = this.head;
        while (node != null) {
            next = node.next;
            if (next == null) {
                headNew = node;
            }
            node.next = prev;
            prev = node;
            node = next;
        }
        this.head = headNew;
    }

    public T getMiddleElement() {
        Node node = this.head;
        Node ret = this.head;
        while (node != null && node.next != null && node.next.next != null) {
            node = node.next.next;
            ret = ret.next;
        }
        return ret.value;
    }

    public boolean isLoop() {
        Node fast = this.head;
        Node slow = this.head;
        while (fast != null && fast.next != null) {
            fast = fast.next.next;
            slow = slow.next;
            if (fast != slow) continue;
            return true;
        }
        return false;
    }

    public boolean isMeetWith(SingleLinkedList<T> list) {
        if (list == null) {
            return false;
        }
        if (this.head == null || list.getHeader() == null) {
            return false;
        }
        Node node1 = this.head;
        while (node1.next != null) {
            node1 = node1.next;
        }
        Node node2 = list.getHeader();
        while (node2.next != null) {
            node2 = node2.next;
        }
        return node1 == node2;
    }

    public Node meetNode(SingleLinkedList<T> list) {
        if (list == null) {
            return null;
        }
        if (this.head == null || list.getHeader() == null) {
            return null;
        }
        int d1 = 0;
        int d2 = 0;
        Node node1 = this.head;
        Node node2 = list.getHeader();
        System.out.println("debug2");
        while (node1.next != null) {
            System.out.println("" + d1 + " " + node1.value);
            node1 = node1.next;
            ++d1;
        }
        System.out.println("debug3");
        while (node2.next != null) {
            node2 = node2.next;
            ++d2;
        }
        if (node1 != node2) {
            return null;
        }
        node1 = this.head;
        node2 = list.getHeader();
        System.out.println("debug");
        if (d1 > d2) {
            while (d1-- > d2) {
                node1 = node1.next;
            }
        } else {
            while (d2-- > d1) {
                node2 = node2.next;
            }
        }
        while (node1 != node2) {
            node1 = node1.next;
            node2 = node2.next;
        }
        return node1;
    }

    public class Node {
        public T value;
        public Node next;

        public Node(T value) {
            this.value = value;
            this.next = null;
        }
    }
}

