/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.toolbox.structure.graph;

import java.util.Stack;

public class MatrixGraph {
    private int[] nodes;
    private int[][] weights;
    private int length;
    private int max;
    private boolean direct;

    public MatrixGraph(int n, boolean direct) {
        this.nodes = new int[n];
        this.weights = new int[n][n];
        this.length = 0;
        this.max = n;
        this.direct = direct;
    }

    public MatrixGraph(int n) {
        this(n, false);
    }

    public boolean addNode(int node) {
        if (this.length < this.max) {
            this.nodes[this.length++] = node;
            return true;
        }
        return false;
    }

    public boolean addWeight(int from, int to, int weight) {
        if (from < 0 || to < 0 || from >= this.length || to >= this.length || from == to) {
            return false;
        }
        this.weights[from][to] = weight;
        if (!this.direct) {
            this.weights[to][from] = weight;
        }
        return true;
    }

    public void show() {
        int i;
        System.out.print("nodes :");
        for (i = 0; i < this.length; ++i) {
            System.out.print(" " + this.nodes[i]);
        }
        System.out.println("");
        System.out.println("weights :");
        for (i = 0; i < this.length; ++i) {
            for (int j = 0; j < this.length; ++j) {
                System.out.print(" " + this.weights[i][j]);
            }
            System.out.println("");
        }
    }

    public void deepVisit() {
        final boolean[] visited = new boolean[this.length];
        class DeepMethod {
            DeepMethod() {
            }

            public void run(int i) {
                visited[i] = true;
                System.out.print(" " + MatrixGraph.this.nodes[i]);
                for (int j = 0; j < MatrixGraph.this.length; ++j) {
                    if (visited[j] || MatrixGraph.this.weights[i][j] == 0) continue;
                    this.run(j);
                }
            }
        }
        DeepMethod method = new DeepMethod();
        System.out.print("deepVisit:");
        for (int i = 0; i < this.length; ++i) {
            if (visited[i]) continue;
            method.run(i);
        }
        System.out.println("");
    }

    public void breadVisit() {
        boolean[] visited = new boolean[this.length];
        Stack<Integer> stack = new Stack<Integer>();
        System.out.print("breadVisit:");
        for (int i = 0; i < this.length; ++i) {
            if (visited[i]) continue;
            visited[i] = true;
            stack.push(i);
            System.out.print(" " + this.nodes[i]);
            while (!stack.empty()) {
                int index = (Integer)stack.pop();
                for (int j = 0; j < this.length; ++j) {
                    if (visited[j] || this.weights[index][j] == 0) continue;
                    visited[j] = true;
                    stack.push(j);
                    System.out.print(" " + this.nodes[j]);
                }
            }
        }
        System.out.println("");
    }

    public void primMinTree() {
        int[] adjvex = new int[this.length];
        int[] lowCost = new int[this.length];
        System.out.print("primMinTree:");
        adjvex[0] = 0;
        lowCost[0] = 0;
        for (int i = 1; i < this.length; ++i) {
            lowCost[i] = this.weights[0][i] == 0 ? Integer.MAX_VALUE : this.weights[0][i];
            adjvex[i] = 0;
        }
        int k = 0;
        int j = 1;
        for (int i = 1; i < this.length; ++i) {
            int min = Integer.MAX_VALUE;
            k = 0;
            for (j = 1; j < this.length; ++j) {
                if (lowCost[j] == 0 || lowCost[j] >= min) continue;
                min = lowCost[j];
                k = j;
            }
            System.out.print(" (" + adjvex[k] + "," + k + ")");
            lowCost[k] = 0;
            for (j = 1; j < this.length; ++j) {
                if (lowCost[j] == 0 || this.weights[k][j] == 0 || this.weights[k][j] >= lowCost[j]) continue;
                lowCost[j] = this.weights[k][j];
                adjvex[j] = k;
            }
        }
        System.out.println("");
    }
}

