/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.toolbox.structure.tree;

import org.caiguoqing.toolbox.pub.CompareHandle;
import org.caiguoqing.toolbox.structure.tree.BinaryNode;
import org.caiguoqing.toolbox.structure.tree.BinaryTree;

public class BinarySearchTree<T>
extends BinaryTree<T> {
    public BinarySearchTree(T value) {
        super(value);
    }

    public BinarySearchTree(T value, CompareHandle handle) {
        super(value, handle);
    }

    public BinaryNode<T> add(T value) {
        BinaryNode x;
        BinaryNode<T> node = new BinaryNode<T>(value);
        BinaryNode pointer = x = this.getRoot();
        while (x != null) {
            pointer = x;
            if (this.compare(x.value, value) <= 0) {
                x = x.right;
                continue;
            }
            x = x.left;
        }
        if (this.compare(pointer.value, value) <= 0) {
            pointer.right = node;
        } else {
            pointer.left = node;
        }
        return node;
    }

    public BinaryNode<T> get(BinaryNode<T> root, T value) {
        if (root == null || value == null) {
            return null;
        }
        if (value.equals(root.value)) {
            return root;
        }
        if (this.compare(value, root.value) < 0) {
            return this.get(root.left, value);
        }
        return this.get(root.right, value);
    }

    public BinaryNode<T> get(T value) {
        if (this.getRoot() == null || value == null) {
            return null;
        }
        return this.get(this.getRoot(), value);
    }

    private boolean delete(BinaryNode<T> node) {
        if (node == null) {
            return false;
        }
        if (node.left == null) {
            BinaryNode temp = node.right;
            node.value = temp.value;
            node.left = temp.left;
            node.right = temp.right;
        } else if (node.right == null) {
            BinaryNode temp = node.left;
            node.value = temp.value;
            node.right = temp.right;
            node.left = temp.left;
        } else {
            BinaryNode<T> q = node;
            BinaryNode s = node.left;
            while (s.right != null) {
                q = s;
                s = s.right;
            }
            node.value = s.value;
            if (q != node) {
                q.right = s.left;
            } else {
                q.left = s.left;
            }
        }
        return true;
    }

    public boolean remove(BinaryNode<T> root, T value) {
        if (root == null || value == null) {
            return false;
        }
        if (value.equals(root.value)) {
            return this.delete(root);
        }
        if (this.compare(value, root.value) < 0) {
            return this.remove(root.left, value);
        }
        return this.remove(root.right, value);
    }

    public boolean remove(T value) {
        if (this.getRoot() == null || value == null) {
            return false;
        }
        return this.remove(this.getRoot(), value);
    }
}

