/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.toolbox.structure.tree;

import org.caiguoqing.toolbox.pub.Compare;
import org.caiguoqing.toolbox.pub.CompareHandle;
import org.caiguoqing.toolbox.structure.LinkedList;
import org.caiguoqing.toolbox.structure.tree.BinaryNode;

public class BinaryTree<T>
extends Compare {
    private BinaryNode<T> root;

    public BinaryTree(T value, CompareHandle handle) {
        super(handle);
        this.root = new BinaryNode<T>(value);
    }

    public BinaryTree(T value) {
        super(null);
        this.root = new BinaryNode<T>(value);
    }

    public BinaryNode<T> getRoot() {
        return this.root;
    }

    public void setRoot(BinaryNode<T> root) {
        this.root = root;
    }

    private void frontLoopDo(BinaryNode<T> node, LinkedList<T> list) {
        if (node == null || list == null) {
            return;
        }
        list.add(node.value);
        this.frontLoopDo(node.left, list);
        this.frontLoopDo(node.right, list);
    }

    private void middleLoopDo(BinaryNode<T> node, LinkedList<T> list) {
        if (node == null || list == null) {
            return;
        }
        this.middleLoopDo(node.left, list);
        list.add(node.value);
        this.middleLoopDo(node.right, list);
    }

    private void backLoopDo(BinaryNode<T> node, LinkedList<T> list) {
        if (node == null || list == null) {
            return;
        }
        this.backLoopDo(node.left, list);
        this.backLoopDo(node.right, list);
        list.add(node.value);
    }

    public LinkedList<T> frontLoop() {
        LinkedList list = new LinkedList();
        this.frontLoopDo(this.root, list);
        return list;
    }

    public LinkedList<T> middleLoop() {
        LinkedList list = new LinkedList();
        this.middleLoopDo(this.root, list);
        return list;
    }

    public LinkedList<T> backLoop() {
        LinkedList list = new LinkedList();
        this.backLoopDo(this.root, list);
        return list;
    }
}

