/**
 * 
 */
package org.caiguoqing.uyuni.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.caiguoqing.uyuni.config.ConsumerConfig;
import org.caiguoqing.uyuni.config.ProtocolConfig;
import org.caiguoqing.uyuni.config.RegistryConfig;
import org.caiguoqing.uyuni.registry.RegistryService;
import org.caiguoqing.uyuni.rpc.client.socketclient.SocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author caiguoqing0427
 *
 */
public class Consumer {
	private Logger logger = LoggerFactory.getLogger(getClass());
	private List<ConsumerConfig> list;
	private RegistryService registry;
	private RegistryConfig registryConfig;
	private ProtocolConfig protocolConfig;
	private Map<String,Object> refers = new HashMap<String,Object>();
	private Map<String,String> ids = new HashMap<String,String>();
	
	/**
	 * @param list list
	 * @param registryConfig registryConfig
	 * @param protocolConfig protocolConfig
	 */
	public Consumer(List<ConsumerConfig> list, RegistryConfig registryConfig, ProtocolConfig protocolConfig) {
		this.list = list;
		this.registryConfig = registryConfig;
		this.protocolConfig = protocolConfig;
	}
	
	private boolean check(){
		if(list == null || list.size() == 0 || registryConfig == null
			|| protocolConfig == null){
			return false;
		}
		return true;
	}
	
	private void registryInit(){
		String address = registryConfig.getAddress();
		int pos = address.indexOf(":");
		String host = address.substring(0, pos);
		int port = Integer.parseInt(address.substring(pos+1));
		try {
			logger.info("connect registry at " + address);
			registry = SocketClient.getInstance().refer(
				RegistryService.class,host,port);
			logger.info("registry is available");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void init(){
		if(!check()){
			return;
		}
		if(registry == null){
			registryInit();
		}

		for(ConsumerConfig config : list){
			logger.info("connect to "+config.getInter());
			List<String> ps = registry.getService(config.getInter());
			if(ps == null || ps.size() == 0){
				logger.error("get " + config.getInter() + " fail");
				continue;
			}
			logger.info("get service at " + ps.get(0));
			URL url = null;
			try {
				url = new URL(ps.get(0));
			} catch (MalformedURLException e1) {
				e1.printStackTrace();
				continue;
			}
			String host = url.getHost();
			int port = url.getPort();
			Class<?> clazz;
			try {
				clazz = Class.forName(config.getInter());
				Object object = SocketClient.getInstance().refer(clazz,host,port);
				refers.put(config.getInter(), object);
				ids.put(config.getId(), config.getInter());
			} catch (ClassNotFoundException e) {
				logger.error(config.getInter()+" not found");
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	public Object getInstance(String inter){
		return refers.get(inter);
	}
	
	public Object getInstanceById(String id){
		return getInstance(ids.get(id));
	}
	
}
