/**
 * 
 */
package org.caiguoqing.uyuni.common;

import org.caiguoqing.uyuni.config.MonitorConfig;
import org.caiguoqing.uyuni.monitor.MonitorService;
import org.caiguoqing.uyuni.rpc.client.socketclient.SocketClient;
import org.caiguoqing.uyuni.rpc.pub.InterCount;

/**
 * @author caiguoqing0427
 *
 */
public class MonitorClient {
	InterCount interCount;
	MonitorService monitorService;
	
	public void init(MonitorConfig config){
		String address = config.getAddress();
		int pos = address.indexOf(":");
		String host = address.substring(0, pos);
		int port = Integer.parseInt(address.substring(pos+1));
		try {
			monitorService = SocketClient.getInstance().refer(
					MonitorService.class,host,port);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
		interCount = SocketClient.getInstance().getCount();
	}
	
	void run(){
		if(interCount == null || monitorService == null){
			return;
		}
		new Thread(new Runnable() {
			public void run() {
				while(true){
					try {
						Thread.sleep(60*1000);
						monitorService.report(interCount.getAll());
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		}).start();
	}
}
