/**
 * 
 */
package org.caiguoqing.uyuni.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.caiguoqing.toolbox.net.IPHelper;
import org.caiguoqing.uyuni.config.ProtocolConfig;
import org.caiguoqing.uyuni.config.ProviderConfig;
import org.caiguoqing.uyuni.config.RegistryConfig;
import org.caiguoqing.uyuni.registry.RegistryService;
import org.caiguoqing.uyuni.rpc.client.socketclient.SocketClient;
import org.caiguoqing.uyuni.rpc.server.Server;
import org.caiguoqing.uyuni.rpc.server.ServerConfig;
import org.caiguoqing.uyuni.rpc.server.ServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author caiguoqing0427
 *
 */
public class Provider {
	private Logger logger = LoggerFactory.getLogger(getClass());
	private List<ProviderConfig> list;
	private RegistryService registry;
	private RegistryConfig registryConfig;
	private ProtocolConfig protocolConfig;
	
	public Provider(List<ProviderConfig> list,RegistryConfig registryConfig
		,ProtocolConfig protocolConfig){
		this.list = list;
		this.registryConfig = registryConfig;
		this.protocolConfig = protocolConfig;
	}
	
	private boolean check(){
		if(list == null || list.size() == 0 || registryConfig == null
			|| protocolConfig == null){
			return false;
		}
		return true;
	}
	
	public void init(){
		if(!check()){
			return;
		}
		String address = registryConfig.getAddress();
		int pos = address.indexOf(":");
		String host = address.substring(0, pos);
		int port = Integer.parseInt(address.substring(pos+1));
		try {
			registry = SocketClient.getInstance().refer(RegistryService.class
					,host,port);
			logger.info("find registry at " + host + ":" + port);
		} catch (Exception e) {
			logger.error("registry not found at " + host + ":" + port);
			e.printStackTrace();
			return;
		}
		
		String ip = IPHelper.getLocalIp();
		port = Integer.parseInt(protocolConfig.getPort());
		Map<String, String> services = new HashMap<String, String>();
		for(ProviderConfig config : list){
			services.put(config.getInter(),config.getClazz());
		}
		
		Server server = ServerFactory.getServer(new ServerConfig(services,port));
		if(server != null){
			server.run();
		}else{
			return;
		}
		
		for(String name : services.keySet()){
			String url = "http://"+ip+":"+protocolConfig.getPort() + "/" + name;
			logger.info("regist service " + url);
			registry.setService(name,url);
		}
	}
}
