/**
 * 
 */
package org.caiguoqing.uyuni.common;

import java.util.List;

import org.caiguoqing.uyuni.config.ConsumerConfig;
import org.caiguoqing.uyuni.config.MonitorConfig;
import org.caiguoqing.uyuni.config.ProtocolConfig;
import org.caiguoqing.uyuni.config.ProviderConfig;
import org.caiguoqing.uyuni.config.RegistryConfig;
import org.caiguoqing.uyuni.config.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author caiguoqing0427
 *
 */
public class Uyuni {
	private Logger logger = LoggerFactory.getLogger(getClass());
	private Scanner scanner = new Scanner();
	private String configFile;
	private List<ProviderConfig> providerConfigs;
	private List<ConsumerConfig> consumerConfigs;
	private RegistryConfig registryConfig;
	private MonitorConfig monitorConfig;
	private ProtocolConfig protocolConfig;
	private Consumer consumer;
	private MonitorClient monitorClient = new MonitorClient();
	
	private Uyuni(){
		
	}
	
	public static Uyuni custom(){
		return new Uyuni();
	}
	
	public Uyuni setConfigFile(String configFile){
		this.configFile = configFile;
		return this;
	}
	
	public Uyuni build(){
		if(configFile != null){
			scanner.scan(configFile).parse();
		}else{
			scanner.scan("provider.xml").parse();
			scanner.scan("consumer.xml").parse();
		}
		registryConfig = scanner.getRegistryConfig();
		protocolConfig = scanner.getProtocolConfig();
		providerConfigs = scanner.getProviderConfigs();
		consumerConfigs = scanner.getConsumerConfigs();
		monitorConfig = scanner.getMonitorConfig();
		return this;
	}
	
	public boolean start(){
		boolean flag = false;
		if(providerConfigs != null && providerConfigs.size() > 0){
			Provider provider = new Provider(providerConfigs, 
				registryConfig, protocolConfig);
			provider.init();
			logger.info("provider start");
			flag = true;
		}
		if(consumerConfigs != null && consumerConfigs.size() > 0){
			consumer = new Consumer(consumerConfigs,
				registryConfig,protocolConfig);
			consumer.init();
			logger.info("consumer start");
			flag = true;
		}
		if(monitorConfig != null){
			monitorClient.init(monitorConfig);
			monitorClient.run();
		}
		return flag;
	}
	
	public Object getInstance(String inter){
		return consumer.getInstance(inter);
	}
	
	public Object getInstanceById(String id){
		return consumer.getInstanceById(id);
	}
	
	/**
	 * @param args args
	 */
	public static void main(String[] args) {
		Uyuni.custom().build().start();
	}

}
