/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.uyuni.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.caiguoqing.uyuni.config.ConsumerConfig;
import org.caiguoqing.uyuni.config.ProtocolConfig;
import org.caiguoqing.uyuni.config.RegistryConfig;
import org.caiguoqing.uyuni.registry.RegistryService;
import org.caiguoqing.uyuni.rpc.client.socketclient.SocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ConsumerConfig> list;
    private RegistryService registry;
    private RegistryConfig registryConfig;
    private ProtocolConfig protocolConfig;
    private Map<String, Object> refers = new HashMap<String, Object>();
    private Map<String, String> ids = new HashMap<String, String>();

    public Consumer(List<ConsumerConfig> list, RegistryConfig registryConfig, ProtocolConfig protocolConfig) {
        this.list = list;
        this.registryConfig = registryConfig;
        this.protocolConfig = protocolConfig;
    }

    private boolean check() {
        return this.list != null && this.list.size() != 0 && this.registryConfig != null && this.protocolConfig != null;
    }

    private void registryInit() {
        String address = this.registryConfig.getAddress();
        int pos = address.indexOf(":");
        String host = address.substring(0, pos);
        int port = Integer.parseInt(address.substring(pos + 1));
        try {
            this.logger.info("connect registry at " + address);
            this.registry = (RegistryService)SocketClient.getInstance().refer(RegistryService.class, host, port);
            this.logger.info("registry is available");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        if (!this.check()) {
            return;
        }
        if (this.registry == null) {
            this.registryInit();
        }
        for (ConsumerConfig config : this.list) {
            this.logger.info("connect to " + config.getInter());
            List ps = this.registry.getService(config.getInter());
            if (ps == null || ps.size() == 0) {
                this.logger.error("get " + config.getInter() + " fail");
                continue;
            }
            this.logger.info("get service at " + (String)ps.get(0));
            URL url = null;
            try {
                url = new URL((String)ps.get(0));
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                continue;
            }
            String host = url.getHost();
            int port = url.getPort();
            try {
                Class<?> clazz = Class.forName(config.getInter());
                Object object = SocketClient.getInstance().refer(clazz, host, port);
                this.refers.put(config.getInter(), object);
                this.ids.put(config.getId(), config.getInter());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(config.getInter() + " not found");
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getInstance(String inter) {
        return this.refers.get(inter);
    }

    public Object getInstanceById(String id) {
        return this.getInstance(this.ids.get(id));
    }
}

