/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.uyuni.common;

import java.util.HashMap;
import java.util.List;
import org.caiguoqing.toolbox.net.IPHelper;
import org.caiguoqing.uyuni.config.ProtocolConfig;
import org.caiguoqing.uyuni.config.ProviderConfig;
import org.caiguoqing.uyuni.config.RegistryConfig;
import org.caiguoqing.uyuni.registry.RegistryService;
import org.caiguoqing.uyuni.rpc.client.socketclient.SocketClient;
import org.caiguoqing.uyuni.rpc.server.Server;
import org.caiguoqing.uyuni.rpc.server.ServerConfig;
import org.caiguoqing.uyuni.rpc.server.ServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Provider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ProviderConfig> list;
    private RegistryService registry;
    private RegistryConfig registryConfig;
    private ProtocolConfig protocolConfig;

    public Provider(List<ProviderConfig> list, RegistryConfig registryConfig, ProtocolConfig protocolConfig) {
        this.list = list;
        this.registryConfig = registryConfig;
        this.protocolConfig = protocolConfig;
    }

    private boolean check() {
        return this.list != null && this.list.size() != 0 && this.registryConfig != null && this.protocolConfig != null;
    }

    public void init() {
        if (!this.check()) {
            return;
        }
        String address = this.registryConfig.getAddress();
        int pos = address.indexOf(":");
        String host = address.substring(0, pos);
        int port = Integer.parseInt(address.substring(pos + 1));
        try {
            this.registry = (RegistryService)SocketClient.getInstance().refer(RegistryService.class, host, port);
            this.logger.info("find registry at " + host + ":" + port);
        }
        catch (Exception e) {
            this.logger.error("registry not found at " + host + ":" + port);
            e.printStackTrace();
            return;
        }
        String ip = IPHelper.getLocalIp();
        port = Integer.parseInt(this.protocolConfig.getPort());
        HashMap<String, String> services = new HashMap<String, String>();
        for (ProviderConfig config : this.list) {
            services.put(config.getInter(), config.getClazz());
        }
        Server server = ServerFactory.getServer((ServerConfig)new ServerConfig(services, port));
        if (server == null) {
            return;
        }
        server.run();
        for (String name : services.keySet()) {
            String url = "http://" + ip + ":" + this.protocolConfig.getPort() + "/" + name;
            this.logger.info("regist service " + url);
            this.registry.setService(name, url);
        }
    }
}

