/*
 * Decompiled with CFR 0.152.
 */
package org.caiguoqing.uyuni.common;

import java.util.List;
import org.caiguoqing.uyuni.common.Consumer;
import org.caiguoqing.uyuni.common.MonitorClient;
import org.caiguoqing.uyuni.common.Provider;
import org.caiguoqing.uyuni.config.ConsumerConfig;
import org.caiguoqing.uyuni.config.MonitorConfig;
import org.caiguoqing.uyuni.config.ProtocolConfig;
import org.caiguoqing.uyuni.config.ProviderConfig;
import org.caiguoqing.uyuni.config.RegistryConfig;
import org.caiguoqing.uyuni.config.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uyuni {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Scanner scanner = new Scanner();
    private String configFile;
    private List<ProviderConfig> providerConfigs;
    private List<ConsumerConfig> consumerConfigs;
    private RegistryConfig registryConfig;
    private MonitorConfig monitorConfig;
    private ProtocolConfig protocolConfig;
    private Consumer consumer;
    private MonitorClient monitorClient = new MonitorClient();

    private Uyuni() {
    }

    public static Uyuni custom() {
        return new Uyuni();
    }

    public Uyuni setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public Uyuni build() {
        if (this.configFile != null) {
            this.scanner.scan(this.configFile).parse();
        } else {
            this.scanner.scan("provider.xml").parse();
            this.scanner.scan("consumer.xml").parse();
        }
        this.registryConfig = this.scanner.getRegistryConfig();
        this.protocolConfig = this.scanner.getProtocolConfig();
        this.providerConfigs = this.scanner.getProviderConfigs();
        this.consumerConfigs = this.scanner.getConsumerConfigs();
        this.monitorConfig = this.scanner.getMonitorConfig();
        return this;
    }

    public boolean start() {
        boolean flag = false;
        if (this.providerConfigs != null && this.providerConfigs.size() > 0) {
            Provider provider = new Provider(this.providerConfigs, this.registryConfig, this.protocolConfig);
            provider.init();
            this.logger.info("provider start");
            flag = true;
        }
        if (this.consumerConfigs != null && this.consumerConfigs.size() > 0) {
            this.consumer = new Consumer(this.consumerConfigs, this.registryConfig, this.protocolConfig);
            this.consumer.init();
            this.logger.info("consumer start");
            flag = true;
        }
        if (this.monitorConfig != null) {
            this.monitorClient.init(this.monitorConfig);
            this.monitorClient.run();
        }
        return flag;
    }

    public Object getInstance(String inter) {
        return this.consumer.getInstance(inter);
    }

    public Object getInstanceById(String id) {
        return this.consumer.getInstanceById(id);
    }

    public static void main(String[] args) {
        Uyuni.custom().build().start();
    }
}

