/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.blobstore.ext.impl;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.blobstore.ext.ExtendedBlobStore;
import org.calrissian.accumulorecipes.blobstore.impl.AccumuloBlobStore;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;

public class ExtendedAccumuloBlobStore
extends AccumuloBlobStore
implements ExtendedBlobStore {
    private static final String PROP_CF = "PROP";
    private static final String SIZE_CF = "SIZE";

    public ExtendedAccumuloBlobStore(Connector connector) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector);
    }

    public ExtendedAccumuloBlobStore(Connector connector, String tableName, StoreConfig config) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector, tableName, config);
    }

    public ExtendedAccumuloBlobStore(Connector connector, int bufferSize) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector, bufferSize);
    }

    public ExtendedAccumuloBlobStore(Connector connector, String tableName, StoreConfig config, int bufferSize) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector, tableName, config, bufferSize);
    }

    @Override
    protected void configureTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        IteratorSetting setting = new IteratorSetting(5, "blob-size", SummingCombiner.class);
        SummingCombiner.setColumns((IteratorSetting)setting, Arrays.asList(new IteratorSetting.Column(SIZE_CF, "")));
        SummingCombiner.setEncodingType((IteratorSetting)setting, (LongCombiner.Type)LongCombiner.Type.STRING);
        connector.tableOperations().attachIterator(tableName, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
    }

    @Override
    protected Mutation generateMutation(String key, String type, byte[] data, int sequenceNum, long timestamp, ColumnVisibility visibility) {
        Mutation m = super.generateMutation(key, type, data, sequenceNum, timestamp, visibility);
        m.put((CharSequence)SIZE_CF, (CharSequence)"", visibility, (CharSequence)Integer.toString(data.length));
        return m;
    }

    @Override
    public int blobSize(String key, String type, Auths auths) {
        Validate.notNull((Object)auths, (String)"Null authorizations");
        try {
            Scanner scanner = this.connector.createScanner(this.tableName, auths.getAuths());
            scanner.setRange(Range.exact((CharSequence)ExtendedAccumuloBlobStore.generateRowId(key, type), (CharSequence)SIZE_CF));
            scanner.fetchColumnFamily(new Text(SIZE_CF));
            scanner.setBatchSize(1);
            Iterator iterator = scanner.iterator();
            if (iterator.hasNext()) {
                return Integer.parseInt(((Value)((Map.Entry)iterator.next()).getValue()).toString());
            }
            return 0;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> getProperties(String key, String type, Auths auths) {
        Validate.notNull((Object)auths, (String)"Null authorizations");
        try {
            Scanner scanner = this.connector.createScanner(this.tableName, auths.getAuths());
            scanner.setRange(Range.exact((CharSequence)ExtendedAccumuloBlobStore.generateRowId(key, type), (CharSequence)PROP_CF));
            scanner.fetchColumnFamily(new Text(PROP_CF));
            Iterator iterator = scanner.iterator();
            if (!iterator.hasNext()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            while (iterator.hasNext()) {
                String[] keyVal = StringUtils.splitPreserveAllTokens((String)((Key)((Map.Entry)iterator.next()).getKey()).getColumnQualifier().toString().replaceFirst("\u0000", ""), (String)"\u0000", (int)2);
                if (keyVal.length != 2) continue;
                properties.put(keyVal[0], keyVal[1]);
            }
            return properties;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OutputStream store(String key, String type, Map<String, String> properties, long timestamp, String visibility) {
        try {
            ColumnVisibility colVis = new ColumnVisibility(StringUtils.defaultString((String)visibility));
            BatchWriter writer = this.getWriter();
            if (properties != null && !properties.isEmpty()) {
                Mutation m = new Mutation((CharSequence)ExtendedAccumuloBlobStore.generateRowId(key, type));
                for (Map.Entry<String, String> prop : properties.entrySet()) {
                    m.put((CharSequence)PROP_CF, (CharSequence)("\u0000" + StringUtils.defaultString((String)prop.getKey()) + "\u0000" + StringUtils.defaultString((String)prop.getValue())), colVis, timestamp, new Value(new byte[0]));
                }
                writer.addMutation(m);
            }
            return this.generateWriteStream(writer, key, type, timestamp, visibility);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

