/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumlorecipes.changelog.iterator;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.hadoop.io.Text;
import org.calrissian.accumlorecipes.changelog.support.BucketSize;
import org.calrissian.accumlorecipes.changelog.support.Utils;

public class BucketRollupIterator
extends WrappingIterator {
    protected BucketSize bucketSize = BucketSize.FIVE_MINS;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (options.containsKey("bucketSize")) {
            this.bucketSize = BucketSize.valueOf(options.get("bucketSize"));
        }
    }

    public boolean hasTop() {
        return super.hasTop();
    }

    public void next() throws IOException {
        super.next();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        super.seek(range, columnFamilies, inclusive);
    }

    public Key getTopKey() {
        Key topKey = super.getTopKey();
        long timestamp = Utils.reverseTimestampToNormalTime(Long.parseLong(topKey.getRow().toString()));
        Key retKey = new Key(new Text(Utils.truncatedReverseTimestamp(timestamp, this.bucketSize).toString()), topKey.getColumnFamily(), topKey.getColumnQualifier(), new Text(topKey.getColumnVisibility().toString()), topKey.getTimestamp());
        return retKey;
    }

    public Value getTopValue() {
        return super.getTopValue();
    }

    public static void setBucketSize(IteratorSetting is, BucketSize bucketSize) {
        is.addOption("bucketSize", bucketSize.name());
    }
}

