/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumlorecipes.changelog.support;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.calrissian.accumlorecipes.changelog.support.BucketSize;
import org.calrissian.accumlorecipes.changelog.support.TupleComparator;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class Utils {
    public static final Long MAX_TIME = 999999999999999999L;
    public static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";

    public static byte[] hashEntry(StoreEntry entry, TypeRegistry<String> typeRegistry) {
        ArrayList tuples = new ArrayList(entry.getTuples());
        Collections.sort(tuples, new TupleComparator(typeRegistry));
        String tupleString = entry.getId();
        for (Tuple tuple : tuples) {
            tupleString = tupleString + Utils.tupleToString(tuple, typeRegistry) + ",";
        }
        try {
            return DigestUtils.md5Hex((String)tupleString).getBytes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Long truncatedReverseTimestamp(long timestamp, BucketSize bucketSize) {
        timestamp -= timestamp % bucketSize.getMs();
        String minutes = new SimpleDateFormat(DATE_FORMAT).format(new Date(timestamp));
        return MAX_TIME - Long.parseLong(minutes);
    }

    public static Long reverseTimestampToNormalTime(long timestamp) {
        Long convert = MAX_TIME - timestamp;
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(Long.toString(convert)).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Long reverseTimestamp(long timestamp) {
        String seconds = new SimpleDateFormat(DATE_FORMAT).format(new Date(timestamp));
        long revTs = MAX_TIME - Long.parseLong(seconds);
        return revTs;
    }

    public static String tupleToString(Tuple tuple, TypeRegistry<String> typeRegistry) {
        try {
            return tuple.getKey() + "\u0000" + (String)typeRegistry.encode(tuple.getValue()) + "\u0000" + tuple.getVisibility();
        }
        catch (TypeEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

