/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumlorecipes.changelog.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.calrissian.accumlorecipes.changelog.ChangelogStore;
import org.calrissian.accumlorecipes.changelog.domain.BucketHashLeaf;
import org.calrissian.accumlorecipes.changelog.iterator.BucketHashIterator;
import org.calrissian.accumlorecipes.changelog.support.BucketSize;
import org.calrissian.accumlorecipes.changelog.support.Utils;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.hadoop.EventWritable;
import org.calrissian.accumulorecipes.commons.support.Scanners;
import org.calrissian.accumulorecipes.commons.support.WritableUtils2;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.hash.tree.MerkleTree;
import org.calrissian.mango.json.tuple.TupleModule;
import org.calrissian.mango.types.LexiTypeEncoders;

public class AccumuloChangelogStore
implements ChangelogStore {
    private static final String DEFAULT_TABLE_NAME = "changelog";
    private static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(3, 100000L, 10000L, 3);
    private final ObjectMapper objectMapper;
    private final String tableName;
    private final Connector connector;
    private final StoreConfig config;
    private final BucketSize bucketSize;
    private final BatchWriter writer;
    private final Function<Map.Entry<Key, Value>, Event> entityTransform = new Function<Map.Entry<Key, Value>, Event>(){

        public Event apply(Map.Entry<Key, Value> entry) {
            try {
                return ((EventWritable)WritableUtils2.asWritable((byte[])entry.getValue().get(), EventWritable.class)).get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public AccumuloChangelogStore(Connector connector) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        this(connector, BucketSize.FIVE_MINS);
    }

    public AccumuloChangelogStore(Connector connector, String tableName, StoreConfig config) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        this(connector, tableName, config, BucketSize.FIVE_MINS);
    }

    public AccumuloChangelogStore(Connector connector, BucketSize bucketSize) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        this(connector, DEFAULT_TABLE_NAME, DEFAULT_STORE_CONFIG, bucketSize);
    }

    public AccumuloChangelogStore(Connector connector, String tableName, StoreConfig config, BucketSize bucketSize) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)((Object)bucketSize));
        this.connector = connector;
        this.tableName = tableName;
        this.config = config;
        this.bucketSize = bucketSize;
        this.objectMapper = new ObjectMapper().registerModule((Module)new TupleModule(LexiTypeEncoders.LEXI_TYPES));
        if (!connector.tableOperations().exists(tableName)) {
            connector.tableOperations().create(tableName);
            this.configureTable(connector, tableName);
        }
        this.writer = connector.createBatchWriter(tableName, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    protected void configureTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void put(Iterable<Event> changes) {
        EventWritable shared = new EventWritable();
        Preconditions.checkNotNull(changes);
        try {
            for (Event change : changes) {
                shared.set(change);
                Mutation m = new Mutation((CharSequence)Long.toString(Utils.truncatedReverseTimestamp(change.getTimestamp(), this.bucketSize)));
                try {
                    Text reverseTimestamp = new Text(Long.toString(Utils.reverseTimestamp(change.getTimestamp())));
                    m.put(reverseTimestamp, new Text(change.getId()), change.getTimestamp(), new Value(WritableUtils2.serialize((Writable)shared)));
                    this.writer.addMutation(m);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() throws Exception {
        this.writer.flush();
    }

    @Override
    public MerkleTree getChangeTree(Date start, Date stop, Auths auths) {
        return this.getChangeTree(start, stop, 4, auths);
    }

    @Override
    public MerkleTree getChangeTree(Date start, Date stop, int dimensions, Auths auths) {
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)stop);
        Preconditions.checkArgument((dimensions > 1 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)auths);
        try {
            Scanner scanner = this.connector.createScanner(this.tableName, auths.getAuths());
            IteratorSetting is = new IteratorSetting(2, BucketHashIterator.class);
            BucketHashIterator.setBucketSize(is, this.bucketSize);
            scanner.addScanIterator(is);
            String startRange = Utils.truncatedReverseTimestamp(start.getTime(), this.bucketSize).toString();
            String endRange = Utils.truncatedReverseTimestamp(stop.getTime(), this.bucketSize).toString();
            scanner.setRange(new Range((CharSequence)endRange, (CharSequence)startRange));
            ArrayList<BucketHashLeaf> leafList = new ArrayList<BucketHashLeaf>();
            Long prevTs = Utils.reverseTimestampToNormalTime(Long.parseLong(endRange));
            int count = 0;
            for (Map.Entry entry : scanner) {
                Long ts = Utils.reverseTimestampToNormalTime(Long.parseLong(((Key)entry.getKey()).getRow().toString()));
                if (count == 0 && (prevTs - ts > this.bucketSize.getMs() || ts > prevTs)) {
                    leafList.add(new BucketHashLeaf("", prevTs));
                }
                while (prevTs - ts > this.bucketSize.getMs()) {
                    leafList.add(new BucketHashLeaf("", prevTs - this.bucketSize.getMs()));
                    prevTs = prevTs - this.bucketSize.getMs();
                }
                leafList.add(new BucketHashLeaf(new String(((Value)entry.getValue()).get()), ts));
                prevTs = ts;
                ++count;
            }
            Long startTs = Utils.reverseTimestampToNormalTime(Long.parseLong(startRange));
            if (count == 0) {
                leafList.add(new BucketHashLeaf("", prevTs));
            }
            while (prevTs - startTs >= this.bucketSize.getMs()) {
                leafList.add(new BucketHashLeaf("", prevTs - this.bucketSize.getMs()));
                prevTs = prevTs - this.bucketSize.getMs();
            }
            return new MerkleTree(leafList, dimensions);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterable<Event> getChanges(Iterable<Date> buckets, Auths auths) {
        Preconditions.checkNotNull(buckets);
        Preconditions.checkNotNull((Object)auths);
        try {
            BatchScanner scanner = this.connector.createBatchScanner(this.tableName, auths.getAuths(), this.config.getMaxQueryThreads());
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (Date date : buckets) {
                Range range = new Range((CharSequence)String.format("%d", Utils.truncatedReverseTimestamp(date.getTime(), this.bucketSize)));
                ranges.add(range);
            }
            scanner.setRanges(ranges);
            return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), this.entityTransform);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

