/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.collect;

import java.util.Iterator;
import java.util.LinkedList;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.mango.collect.CloseableIterator;
import org.calrissian.mango.collect.CloseableIterators;
import org.calrissian.mango.collect.PeekingCloseableIterator;

public class StoreEntryMergeJoinIterable
implements Iterable<StoreEntry> {
    private Iterable<Iterable<StoreEntry>> cursors;

    public StoreEntryMergeJoinIterable(Iterable<Iterable<StoreEntry>> cursors) {
        this.cursors = cursors;
    }

    @Override
    public Iterator iterator() {
        final LinkedList<PeekingCloseableIterator> iterators = new LinkedList<PeekingCloseableIterator>();
        for (Iterable<StoreEntry> entries : this.cursors) {
            iterators.add(CloseableIterators.peekingIterator((CloseableIterator)CloseableIterators.wrap(entries.iterator())));
        }
        return new Iterator<StoreEntry>(){

            @Override
            public boolean hasNext() {
                for (Iterator entry : iterators) {
                    if (!entry.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public StoreEntry next() {
                PeekingCloseableIterator curEntry = null;
                for (PeekingCloseableIterator itr : iterators) {
                    if (!itr.hasNext() || curEntry != null && ((StoreEntry)itr.peek()).getTimestamp() <= ((StoreEntry)curEntry.peek()).getTimestamp()) continue;
                    curEntry = itr;
                }
                return (StoreEntry)curEntry.next();
            }

            @Override
            public void remove() {
                for (Iterator itr : iterators) {
                    itr.remove();
                }
            }
        };
    }
}

