/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.calrissian.mango.domain.Tuple;

public class StoreEntry {
    protected final String id;
    protected final long timestamp;
    protected Collection<Tuple> tuples;

    public StoreEntry() {
        this(UUID.randomUUID().toString());
    }

    public StoreEntry(String id) {
        this(id, System.currentTimeMillis());
    }

    public StoreEntry(String id, long timestamp) {
        this.id = id;
        this.timestamp = timestamp;
        this.tuples = new ArrayList<Tuple>();
    }

    public void putAll(Collection<Tuple> tuples) {
        if (tuples != null) {
            this.tuples.addAll(tuples);
        }
    }

    public void put(Tuple tuple) {
        this.tuples.add(tuple);
    }

    public Tuple get(String key) {
        for (Tuple tuple : this.tuples) {
            if (!tuple.getKey().equals(key)) continue;
            return tuple;
        }
        return null;
    }

    public Collection<Tuple> getAll(String key) {
        ArrayList<Tuple> retTuples = new ArrayList<Tuple>();
        for (Tuple tuple : this.tuples) {
            if (!tuple.getKey().equals(key)) continue;
            retTuples.add(tuple);
        }
        return retTuples;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<Tuple> getTuples() {
        return this.tuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoreEntry)) {
            return false;
        }
        StoreEntry event = (StoreEntry)o;
        if (this.timestamp != event.timestamp) {
            return false;
        }
        if (this.id != null ? !this.id.equals(event.id) : event.id != null) {
            return false;
        }
        return !(this.tuples != null ? !this.tuples.equals(event.tuples) : event.tuples != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.tuples != null ? this.tuples.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StoreEntry{id='" + this.id + '\'' + ", timestamp=" + this.timestamp + ", tuples=" + this.tuples + '}';
    }
}

