/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.hadoop;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Partitioner;
import org.calrissian.accumulorecipes.commons.hadoop.GroupedKey;

public class GroupedKeyRangePartitioner
extends Partitioner<GroupedKey, Writable>
implements Configurable {
    private static final String PREFIX = GroupedKeyRangePartitioner.class.getName();
    private static final String GROUPS_KEY = ".groups";
    private static final String CUTFILE_KEY = PREFIX + ".cutFile";
    private static final String NUM_SUBBINS = PREFIX + ".subBins";
    public static final String DELIM = "\u0000";
    private Configuration conf;
    private int _numSubBins = 0;
    private Text[] cutPointArray = null;

    public int getPartition(GroupedKey key, Writable value, int numPartitions) {
        try {
            return this.findPartition(key.getGroup(), key.getKey().getRow(), this.getCutPoints(), this.getNumSubBins());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    int findPartition(String group, Text key, Text[] array, int numSubBins) {
        int index = Arrays.binarySearch(array, new Text(group + DELIM + key));
        int n = index = index < 0 ? (index + 1) * -1 : index;
        if (numSubBins < 2) {
            return index;
        }
        return (key.toString().hashCode() & Integer.MAX_VALUE) % numSubBins + index * numSubBins;
    }

    private synchronized int getNumSubBins() {
        if (this._numSubBins < 1) {
            this._numSubBins = Math.max(1, this.getConf().getInt(NUM_SUBBINS, 1));
        }
        return this._numSubBins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Text[] getCutPoints() throws IOException {
        Path[] cf;
        if (this.cutPointArray == null && (cf = DistributedCache.getLocalCacheFiles((Configuration)this.conf)) != null) {
            Map<String, String> curFilesAndGroups = this.getCurFilesAndGroups();
            TreeMap cutPointMap = new TreeMap();
            int i$ = 0;
            Path[] arr$ = cf;
            int len$ = arr$.length;
            if (i$ < len$) {
                Path path = arr$[i$];
                String group = null;
                for (Map.Entry<String, String> groupSplits : curFilesAndGroups.entrySet()) {
                    if (!path.toString().endsWith(groupSplits.getKey())) continue;
                    group = groupSplits.getValue();
                }
                if (group != null) {
                    Scanner in = new Scanner(new BufferedReader(new FileReader(path.toString())));
                    try {
                        while (in.hasNextLine()) {
                            String split = new String(Base64.decodeBase64((byte[])in.nextLine().getBytes()));
                            TreeSet splits = (TreeSet)cutPointMap.get(group);
                            if (splits != null) continue;
                            splits = new TreeSet();
                            cutPointMap.put(group, splits);
                        }
                        TreeSet<Text> treeSet = new TreeSet<Text>();
                        for (Map.Entry entry : cutPointMap.entrySet()) {
                            treeSet.add(new Text((String)entry.getKey() + DELIM + DELIM));
                            for (String string : (SortedSet)entry.getValue()) {
                                treeSet.add(new Text((String)entry.getKey() + DELIM + string));
                            }
                            treeSet.add(new Text((String)entry.getKey() + DELIM + "\uffff"));
                        }
                        this.cutPointArray = treeSet.toArray(new Text[0]);
                    }
                    finally {
                        in.close();
                    }
                } else {
                    throw new FileNotFoundException("A file was not found in distribution cache files: " + path.toString());
                }
            }
        }
        return this.cutPointArray;
    }

    private Map<String, String> getCurFilesAndGroups() {
        String[] groups;
        TreeMap<String, String> retMap = new TreeMap<String, String>();
        for (String group : groups = this.conf.getStrings(GROUPS_KEY)) {
            retMap.put(this.conf.get(".groups." + group), group);
        }
        return retMap;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public static void addSplitFile(JobContext job, String group, String file) {
        URI uri = new Path(file).toUri();
        DistributedCache.addCacheFile((URI)uri, (Configuration)job.getConfiguration());
        Object[] groups = job.getConfiguration().getStrings(GROUPS_KEY);
        if (groups == null || Arrays.binarySearch(groups, group) == -1) {
            String[] newGroups = groups != null ? (String[])Arrays.copyOf(groups, groups.length + 1) : new String[]{};
            newGroups[newGroups.length - 1] = group;
            job.getConfiguration().setStrings(GROUPS_KEY, newGroups);
            job.getConfiguration().set(".groups." + group, file);
        }
    }

    public static void setNumSubBins(JobContext job, int num) {
        job.getConfiguration().setInt(NUM_SUBBINS, num);
    }
}

