/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;

public class FirstNEntriesInRowIterator
implements OptionDescriber,
SortedKeyValueIterator<Key, Value> {
    private SortedKeyValueIterator<Key, Value> source = null;
    static final String NUM_SCANS_STRING_NAME = "scansBeforeSeek";
    static final String NUM_KEYS_STRING_NAME = "n";
    private Range latestRange;
    private Collection<ByteSequence> latestColumnFamilies;
    private boolean latestInclusive;
    private Text lastRowFound;
    private int numscans;
    private Key topKey;
    private Value topValue;
    private List<Key> keys = new ArrayList<Key>();
    private List<Value> values = new ArrayList<Value>();
    private int n;
    private boolean finished = true;

    public static void setNumScansBeforeSeek(IteratorSetting cfg, int num) {
        cfg.addOption(NUM_SCANS_STRING_NAME, Integer.toString(num));
    }

    public static void setNumKeysToReturn(IteratorSetting cfg, int n) {
        cfg.addOption(NUM_KEYS_STRING_NAME, Integer.toString(n));
    }

    public FirstNEntriesInRowIterator() {
    }

    public FirstNEntriesInRowIterator(FirstNEntriesInRowIterator other, IteratorEnvironment env) {
        this.setSource((SortedKeyValueIterator<Key, Value>)other.getSource().deepCopy(env));
    }

    protected void setSource(SortedKeyValueIterator<Key, Value> source) {
        this.source = source;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new FirstNEntriesInRowIterator(this, env);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        String o = options.get(NUM_SCANS_STRING_NAME);
        String nStr = options.get(NUM_KEYS_STRING_NAME);
        this.n = nStr == null ? 25 : Integer.parseInt(nStr);
        this.numscans = o == null ? 10 : Integer.parseInt(o);
        this.setSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env));
    }

    private void prepKeys() throws IOException {
        if (this.lastRowFound == null) {
            this.topKey = null;
            this.topValue = null;
            return;
        }
        this.keys.clear();
        this.values.clear();
        while (this.getSource().hasTop() && this.keys.size() < this.n && ((Key)this.getSource().getTopKey()).getRow().equals((Object)this.lastRowFound)) {
            this.keys.add(new Key((Key)this.getSource().getTopKey()));
            this.values.add(new Value((Value)this.getSource().getTopValue()));
            this.getSource().next();
        }
        this.topKey = new Key(this.lastRowFound, this.keys.get(0).getColumnFamily());
        this.topValue = FirstNEntriesInRowIterator.encodeRow(this.keys, this.values);
    }

    public boolean hasTop() {
        return !this.finished && (this.topKey != null || this.getSource().hasTop());
    }

    public void next() throws IOException {
        this.skipRow();
        this.prepKeys();
    }

    protected SortedKeyValueIterator<Key, Value> getSource() {
        if (this.source == null) {
            throw new IllegalStateException("getting null source");
        }
        return this.source;
    }

    protected void skipRow() throws IOException {
        if (this.finished || this.lastRowFound == null) {
            return;
        }
        int count = 0;
        while (this.getSource().hasTop() && this.lastRowFound.equals((Object)((Key)this.getSource().getTopKey()).getRow())) {
            if (count < this.numscans) {
                ++count;
                this.getSource().next();
                continue;
            }
            count = 0;
            Key nextKey = ((Key)this.getSource().getTopKey()).followingKey(PartialKey.ROW);
            if (!this.latestRange.afterEndKey(nextKey)) {
                this.getSource().seek(new Range(nextKey, true, this.latestRange.getEndKey(), this.latestRange.isEndKeyInclusive()), this.latestColumnFamilies, this.latestInclusive);
                continue;
            }
            this.finished = true;
            break;
        }
        this.lastRowFound = this.getSource().hasTop() ? ((Key)this.getSource().getTopKey()).getRow(this.lastRowFound) : null;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.latestRange = range;
        this.latestColumnFamilies = columnFamilies;
        this.latestInclusive = inclusive;
        this.lastRowFound = null;
        Key startKey = range.getStartKey();
        Range seekRange = new Range(startKey == null ? null : new Key(startKey.getRow()), true, range.getEndKey(), range.isEndKeyInclusive());
        this.getSource().seek(seekRange, columnFamilies, inclusive);
        this.finished = false;
        if (this.getSource().hasTop()) {
            this.lastRowFound = ((Key)this.getSource().getTopKey()).getRow();
            if (range.beforeStartKey((Key)this.getSource().getTopKey())) {
                this.skipRow();
            }
        }
        this.prepKeys();
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        String name = "firstNEntriesInRowIterator";
        String desc = "Only allows iteration over the first n entries per row";
        HashMap<String, String> namedOptions = new HashMap<String, String>();
        namedOptions.put(NUM_SCANS_STRING_NAME, "Number of scans to try before seeking [10]");
        namedOptions.put(NUM_KEYS_STRING_NAME, "Number of entries to keep per row [25]");
        return new OptionDescriber.IteratorOptions(name, desc, namedOptions, null);
    }

    public boolean validateOptions(Map<String, String> options) {
        try {
            String nStr;
            String o = options.get(NUM_SCANS_STRING_NAME);
            if (o != null) {
                Integer.parseInt(o);
            }
            if ((nStr = options.get(NUM_KEYS_STRING_NAME)) != null) {
                Integer.parseInt(nStr);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad integer scansBeforeSeek:" + options.get(NUM_SCANS_STRING_NAME), e);
        }
        return true;
    }

    public static final List<Map.Entry<Key, Value>> decodeRow(Key rowKey, Value rowValue) throws IOException {
        ArrayList<Map.Entry<Key, Value>> map = new ArrayList<Map.Entry<Key, Value>>();
        ByteArrayInputStream in = new ByteArrayInputStream(rowValue.get());
        DataInputStream din = new DataInputStream(in);
        int numKeys = din.readInt();
        for (int i = 0; i < numKeys; ++i) {
            int len = din.readInt();
            byte[] cf = new byte[len];
            din.read(cf);
            len = din.readInt();
            byte[] cq = new byte[len];
            din.read(cq);
            len = din.readInt();
            byte[] cv = new byte[len];
            din.read(cv);
            long timestamp = din.readLong();
            int len2 = din.readInt();
            byte[] valBytes = new byte[len2];
            din.read(valBytes);
            map.add(Maps.immutableEntry((Object)new Key(rowKey.getRowData().toArray(), cf, cq, cv, timestamp, false, false), (Object)new Value(valBytes, false)));
        }
        return map;
    }

    public static final Value encodeRow(List<Key> keys, List<Value> values) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            Key k = keys.get(i);
            Value v = values.get(i);
            ByteSequence bs = k.getColumnFamilyData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            bs = k.getColumnQualifierData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            bs = k.getColumnVisibilityData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            dout.writeLong(k.getTimestamp());
            byte[] valBytes = v.get();
            dout.writeInt(valBytes.length);
            dout.write(valBytes);
        }
        return new Value(out.toByteArray());
    }
}

