/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.support;

import org.calrissian.accumulorecipes.commons.support.MetricTimeUnit;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimestampUtil {
    private static final DateTimeFormatter MINUTES_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
    private static final DateTimeFormatter HOURS_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMddHH");
    private static final DateTimeFormatter DAYS_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final DateTimeFormatter MONTHS_FORMAT = DateTimeFormat.forPattern((String)"yyyyMM");

    private TimestampUtil() {
    }

    private static String reverse(String timestamp) {
        return Long.toString(Long.MAX_VALUE - Long.parseLong(timestamp));
    }

    public static String generateTimestamp(long timestamp, MetricTimeUnit timeUnit) {
        switch (timeUnit) {
            case MINUTES: {
                return TimestampUtil.reverse(MINUTES_FORMAT.print(timestamp));
            }
            case HOURS: {
                return TimestampUtil.reverse(HOURS_FORMAT.print(timestamp));
            }
            case DAYS: {
                return TimestampUtil.reverse(DAYS_FORMAT.print(timestamp));
            }
            case MONTHS: {
                return TimestampUtil.reverse(MONTHS_FORMAT.print(timestamp));
            }
        }
        throw new IllegalArgumentException("Unsupported time unit");
    }

    public static long revertTimestamp(String timestamp, MetricTimeUnit timeUnit) {
        switch (timeUnit) {
            case MINUTES: {
                return MINUTES_FORMAT.parseMillis(TimestampUtil.reverse(timestamp));
            }
            case HOURS: {
                return HOURS_FORMAT.parseMillis(TimestampUtil.reverse(timestamp));
            }
            case DAYS: {
                return DAYS_FORMAT.parseMillis(TimestampUtil.reverse(timestamp));
            }
            case MONTHS: {
                return MONTHS_FORMAT.parseMillis(TimestampUtil.reverse(timestamp));
            }
        }
        throw new IllegalArgumentException("Unsupported time unit");
    }
}

