/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.collect;

import java.util.Iterator;
import java.util.LinkedList;
import org.calrissian.mango.collect.CloseableIterator;
import org.calrissian.mango.collect.CloseableIterators;
import org.calrissian.mango.collect.PeekingCloseableIterator;
import org.calrissian.mango.domain.event.Event;

public class EventMergeJoinIterable
implements Iterable<Event> {
    private Iterable<Iterable<Event>> cursors;

    public EventMergeJoinIterable(Iterable<Iterable<Event>> cursors) {
        this.cursors = cursors;
    }

    @Override
    public Iterator<Event> iterator() {
        final LinkedList<PeekingCloseableIterator> iterators = new LinkedList<PeekingCloseableIterator>();
        for (Iterable<Event> entries : this.cursors) {
            iterators.add(CloseableIterators.peekingIterator((CloseableIterator)CloseableIterators.wrap(entries.iterator())));
        }
        return new Iterator<Event>(){

            @Override
            public boolean hasNext() {
                for (Iterator entry : iterators) {
                    if (!entry.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Event next() {
                PeekingCloseableIterator curEntry = null;
                for (PeekingCloseableIterator itr : iterators) {
                    if (!itr.hasNext() || curEntry != null && ((Event)itr.peek()).getTimestamp() <= ((Event)curEntry.peek()).getTimestamp()) continue;
                    curEntry = itr;
                }
                return (Event)curEntry.next();
            }

            @Override
            public void remove() {
                for (Iterator itr : iterators) {
                    itr.remove();
                }
            }
        };
    }
}

