/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.hadoop;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.calrissian.accumulorecipes.commons.domain.Settable;
import org.calrissian.accumulorecipes.commons.iterators.OptimizedQueryIterator;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;
import org.calrissian.accumulorecipes.commons.iterators.support.NodeToJexl;
import org.calrissian.accumulorecipes.commons.support.criteria.QueryOptimizer;
import org.calrissian.accumulorecipes.commons.support.criteria.visitors.GlobalIndexVisitor;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.types.TypeRegistry;

public abstract class BaseQfdInputFormat<T extends TupleStore, W extends Settable>
extends InputFormatBase<Key, W> {
    protected static void configureScanner(Configuration config, Node query, GlobalIndexVisitor globalInexVisitor, TypeRegistry<String> typeRegistry) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        QueryOptimizer optimizer = new QueryOptimizer(query, globalInexVisitor, typeRegistry);
        NodeToJexl nodeToJexl = new NodeToJexl(typeRegistry);
        String jexl = nodeToJexl.transform(optimizer.getOptimizedQuery());
        String originalJexl = nodeToJexl.transform(query);
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (jexl.equals("()") || jexl.equals("")) {
            ranges.add(new Range((CharSequence)"\uffff"));
        } else {
            for (String shard : optimizer.getShards()) {
                ranges.add(new Range((CharSequence)shard));
            }
        }
        BaseQfdInputFormat.setRanges((Configuration)config, ranges);
        IteratorSetting setting = new IteratorSetting(16, OptimizedQueryIterator.class);
        setting.addOption("expr", originalJexl);
        setting.addOption("FIELD_INDEX_QUERY", jexl);
        BaseQfdInputFormat.addIterator((Configuration)config, (IteratorSetting)setting);
    }

    protected abstract Function<Map.Entry<Key, Value>, T> getTransform(Configuration var1);

    protected abstract W getWritable();

    public RecordReader<Key, W> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        W sharedWritable = this.getWritable();
        Kryo kryo = new Kryo();
        EventFields.initializeKryo(kryo);
        Function<Map.Entry<Key, Value>, T> xform = this.getTransform(context.getConfiguration());
        return new InputFormatBase.RecordReaderBase<Key, W>((Settable)sharedWritable, (Function)xform){
            final /* synthetic */ Settable val$sharedWritable;
            final /* synthetic */ Function val$xform;
            {
                this.val$sharedWritable = settable;
                this.val$xform = function;
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.scannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                    this.currentKey = (Key)entry.getKey();
                    this.currentK = this.currentKey;
                    this.val$sharedWritable.set(this.val$xform.apply((Object)entry));
                    this.currentV = this.val$sharedWritable;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)true)));
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

