/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.calrissian.accumulorecipes.commons.domain.Gettable;
import org.calrissian.accumulorecipes.commons.domain.Settable;
import org.calrissian.accumulorecipes.commons.hadoop.TupleWritable;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.event.BaseEvent;
import org.calrissian.mango.domain.event.Event;

public class EventWritable
implements Writable,
Settable<Event>,
Gettable<Event> {
    private TupleWritable tupleWritable = new TupleWritable();
    Event entry;

    public EventWritable() {
    }

    public EventWritable(Event entry) {
        this.entry = entry;
    }

    public void setTupleWritable(TupleWritable sharedTupleWritable) {
        this.tupleWritable = sharedTupleWritable;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.entry.getId());
        dataOutput.writeLong(this.entry.getTimestamp());
        dataOutput.writeInt(this.entry.getTuples() != null ? this.entry.getTuples().size() : 0);
        for (Tuple tuple : this.entry.getTuples()) {
            this.tupleWritable.set(tuple);
            this.tupleWritable.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        String uuid = dataInput.readUTF();
        long timestamp = dataInput.readLong();
        this.entry = new BaseEvent(uuid, timestamp);
        int count = dataInput.readInt();
        for (int i = 0; i < count; ++i) {
            this.tupleWritable.readFields(dataInput);
            this.entry.put(this.tupleWritable.get());
        }
    }

    @Override
    public void set(Event entry) {
        this.entry = entry;
    }

    @Override
    public Event get() {
        return this.entry;
    }
}

