/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.data.Key;
import org.apache.hadoop.io.WritableComparable;

public class GroupedKey
implements WritableComparable<GroupedKey> {
    private String group;
    private Key key;

    public GroupedKey(String group, Key key) {
        this.group = group;
        this.key = key;
    }

    public String getGroup() {
        return this.group;
    }

    public Key getKey() {
        return this.key;
    }

    public int compareTo(GroupedKey groupedKey) {
        int result = this.getGroup().compareTo(groupedKey.getGroup());
        if (result == 0) {
            result = this.getKey().compareTo(groupedKey.getKey());
        }
        return result;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.group);
        this.key.write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.group = dataInput.readUTF();
        this.key = new Key();
        this.key.readFields(dataInput);
    }
}

