/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.Writable;
import org.calrissian.accumulorecipes.commons.domain.Gettable;
import org.calrissian.accumulorecipes.commons.domain.Settable;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class TupleWritable
implements Writable,
Gettable<Tuple>,
Settable<Tuple> {
    private Tuple tuple;
    private TypeRegistry<String> typeRegistry = LexiTypeEncoders.LEXI_TYPES;

    public TupleWritable() {
    }

    public TupleWritable(Tuple tuple) {
        this.tuple = tuple;
    }

    public void setTypeRegistry(TypeRegistry<String> registry) {
        this.typeRegistry = registry;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.tuple.getKey());
        dataOutput.writeUTF(this.typeRegistry.getAlias(this.tuple.getValue()));
        dataOutput.writeUTF((String)this.typeRegistry.encode(this.tuple.getValue()));
        Set metaMap = this.tuple.getMetadata().entrySet();
        int finalMeta = 0;
        for (Map.Entry meta : metaMap) {
            if (meta.getValue() == null) continue;
            ++finalMeta;
        }
        dataOutput.writeInt(finalMeta);
        for (Map.Entry meta : metaMap) {
            if (meta.getValue() == null) continue;
            dataOutput.writeUTF((String)meta.getKey());
            dataOutput.writeUTF(this.typeRegistry.getAlias(meta.getValue()));
            dataOutput.writeUTF((String)this.typeRegistry.encode(meta.getValue()));
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        String key = dataInput.readUTF();
        String type = dataInput.readUTF();
        String val = dataInput.readUTF();
        int count = dataInput.readInt();
        HashMap<String, Object> metadata = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            String metaKey = dataInput.readUTF();
            String metaType = dataInput.readUTF();
            String metaVal = dataInput.readUTF();
            metadata.put(metaKey, this.typeRegistry.decode(metaType, (Object)metaVal));
        }
        this.tuple = new Tuple(key, this.typeRegistry.decode(type, (Object)val), metadata);
    }

    @Override
    public Tuple get() {
        return this.tuple;
    }

    @Override
    public void set(Tuple item) {
        this.tuple = item;
    }
}

