/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import com.esotericsoftware.kryo.Kryo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.jexl2.parser.ParseException;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;
import org.calrissian.accumulorecipes.commons.iterators.support.QueryEvaluator;

public abstract class AbstractEvaluatingIterator
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    public static final String QUERY_OPTION = "expr";
    public static final String UNEVALUTED_EXPRESSIONS = "unevaluated.expressions";
    protected static final byte[] EMPTY_BYTE = new byte[0];
    private static Logger log = Logger.getLogger(AbstractEvaluatingIterator.class);
    private static Kryo kryo = new Kryo();
    protected SortedKeyValueIterator<Key, Value> iterator;
    private PartialKey comparator = null;
    private Key currentKey = new Key();
    private Key returnKey;
    private Value returnValue;
    private String expression;
    private QueryEvaluator evaluator;
    private EventFields event = null;
    private Range seekRange = null;
    private Set<String> skipExpressions = null;

    protected AbstractEvaluatingIterator(AbstractEvaluatingIterator other, IteratorEnvironment env) {
        this.iterator = other.iterator.deepCopy(env);
        this.event = other.event;
    }

    public AbstractEvaluatingIterator() {
    }

    static Range maximizeStartKeyTimeStamp(Range range) {
        Range seekRange = range;
        if (range.getStartKey() != null && range.getStartKey().getTimestamp() != Long.MAX_VALUE) {
            Key seekKey = new Key(seekRange.getStartKey());
            seekKey.setTimestamp(Long.MAX_VALUE);
            seekRange = new Range(seekKey, true, range.getEndKey(), range.isEndKeyInclusive());
        }
        return seekRange;
    }

    public abstract PartialKey getKeyComparator();

    public abstract Key getReturnKey(Key var1) throws Exception;

    public abstract void fillMap(EventFields var1, Key var2, Value var3) throws Exception;

    public abstract boolean isKeyAccepted(Key var1) throws IOException;

    public void reset() {
        this.event.clear();
    }

    private void aggregateRowColumn(EventFields event) throws IOException {
        this.currentKey.set((Key)this.iterator.getTopKey());
        try {
            this.fillMap(event, (Key)this.iterator.getTopKey(), (Value)this.iterator.getTopValue());
            this.iterator.next();
            while (this.iterator.hasTop() && ((Key)this.iterator.getTopKey()).equals(this.currentKey, this.comparator)) {
                this.fillMap(event, (Key)this.iterator.getTopKey(), (Value)this.iterator.getTopValue());
                this.iterator.next();
            }
            this.returnKey = this.getReturnKey(this.currentKey);
        }
        catch (Exception e) {
            throw new IOException("Error aggregating event", e);
        }
    }

    private void findTop() throws IOException {
        do {
            this.reset();
            if (this.iterator.hasTop()) {
                while (this.iterator.hasTop() && !this.isKeyAccepted((Key)this.iterator.getTopKey())) {
                    this.iterator.next();
                }
                if (this.iterator.hasTop()) {
                    this.aggregateRowColumn(this.event);
                    if (this.event.size() > 0 && this.evaluator.evaluate(this.event)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Event evaluated to true, key = " + this.returnKey));
                        }
                        byte[] serializedMap = new byte[this.event.getByteSize() + this.event.size() * 20];
                        ByteBuffer buf = ByteBuffer.wrap(serializedMap);
                        this.event.writeObjectData(kryo, buf);
                        this.returnValue = new Value(Arrays.copyOfRange(serializedMap, 0, buf.position()));
                        continue;
                    }
                    this.returnKey = null;
                    this.returnValue = null;
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Iterator no longer has top.");
                continue;
            }
            log.debug((Object)"Iterator.hasTop() == false");
        } while (this.returnValue == null && this.iterator.hasTop());
        if (!(this.returnKey == null && this.returnValue == null || this.returnKey != null && this.returnValue != null)) {
            log.warn((Object)("Key: " + (this.returnKey == null ? "null" : this.returnKey.toString())));
            log.warn((Object)("Value: " + (this.returnValue == null ? "null" : this.returnValue.toString())));
            throw new IOException("Return values are inconsistent");
        }
    }

    public Key getTopKey() {
        if (this.returnKey != null) {
            return this.returnKey;
        }
        return (Key)this.iterator.getTopKey();
    }

    public Value getTopValue() {
        if (this.returnValue != null) {
            return this.returnValue;
        }
        return (Value)this.iterator.getTopValue();
    }

    public boolean hasTop() {
        return this.returnKey != null || this.iterator.hasTop();
    }

    public void next() throws IOException {
        if (this.returnKey != null) {
            this.returnKey = null;
            this.returnValue = null;
        } else if (this.iterator.hasTop()) {
            this.iterator.next();
        }
        this.findTop();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.seekRange = AbstractEvaluatingIterator.maximizeStartKeyTimeStamp(range);
        this.iterator.seek(this.seekRange, columnFamilies, inclusive);
        this.findTop();
        if (range.getStartKey() != null) {
            while (this.hasTop() && this.getTopKey().equals(range.getStartKey(), this.comparator) && this.getTopKey().getTimestamp() > range.getStartKey().getTimestamp()) {
                this.next();
            }
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.validateOptions(options);
        this.event = new EventFields();
        this.comparator = this.getKeyComparator();
        this.iterator = source;
        try {
            if (null != this.skipExpressions && this.skipExpressions.size() != 0) {
                for (String skip : this.skipExpressions) {
                    String field = skip.substring(0, skip.indexOf(" ") - 1);
                    this.expression = this.expression.replaceAll(skip, field + " == null");
                }
            }
            this.evaluator = new QueryEvaluator(this.expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse criteria", e);
        }
        EventFields.initializeKryo(kryo);
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(QUERY_OPTION, "criteria expression");
        options.put(UNEVALUTED_EXPRESSIONS, "comma separated list of expressions to skip");
        return new OptionDescriber.IteratorOptions(this.getClass().getSimpleName(), "evaluates event objects against an expression", options, null);
    }

    public boolean validateOptions(Map<String, String> options) {
        String expressionList;
        if (!options.containsKey(QUERY_OPTION)) {
            return false;
        }
        this.expression = options.get(QUERY_OPTION);
        if (options.containsKey(UNEVALUTED_EXPRESSIONS) && (expressionList = options.get(UNEVALUTED_EXPRESSIONS)) != null && !expressionList.trim().equals("")) {
            this.skipExpressions = new HashSet<String>();
            for (String e : expressionList.split(",")) {
                this.skipExpressions.add(e);
            }
        }
        return true;
    }

    public String getQueryExpression() {
        return this.expression;
    }
}

