/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class AndIterator
implements SortedKeyValueIterator<Key, Value> {
    public static final String columnFamiliesOptionName = "columnFamilies";
    public static final String termValuesOptionName = "termValues";
    public static final String notFlagsOptionName = "notFlags";
    protected static final Logger log = Logger.getLogger(AndIterator.class);
    private static boolean SEEK_INCLUSIVE = true;
    protected final byte[] emptyByteArray = new byte[0];
    protected Value value = new Value(this.emptyByteArray);
    private Text currentTerm = new Text(this.emptyByteArray);
    private Text currentDocID = new Text(this.emptyByteArray);
    protected Text nullText = new Text();
    private TermSource[] sources;
    private int sourcesCount = 0;
    private Key topKey = null;
    private Range overallRange;
    private Text currentRow = null;
    private Text parentEndRow;

    public AndIterator() {
    }

    public AndIterator(AndIterator other, IteratorEnvironment env) {
        if (other.sources != null) {
            this.sourcesCount = other.sourcesCount;
            this.sources = new TermSource[this.sourcesCount];
            for (int i = 0; i < this.sourcesCount; ++i) {
                this.sources[i] = new TermSource((SortedKeyValueIterator<Key, Value>)other.sources[i].iter.deepCopy(env), other.sources[i].dataLocation, other.sources[i].term);
            }
        }
    }

    public static String stringTopKey(SortedKeyValueIterator<Key, Value> iter) {
        if (iter.hasTop()) {
            return ((Key)iter.getTopKey()).toString();
        }
        return "";
    }

    public static String encodeColumns(Text[] columns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            sb.append(new String(Base64.encodeBase64((byte[])TextUtil.getBytes((Text)columns[i]))));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String encodeTermValues(Text[] terms) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < terms.length; ++i) {
            sb.append(new String(Base64.encodeBase64((byte[])TextUtil.getBytes((Text)terms[i]))));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String encodeBooleans(boolean[] flags) {
        byte[] bytes = new byte[flags.length];
        for (int i = 0; i < flags.length; ++i) {
            bytes[i] = flags[i] ? (byte)1 : 0;
        }
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static Text[] decodeColumns(String columns) {
        String[] columnStrings = columns.split("\n");
        Text[] columnTexts = new Text[columnStrings.length];
        for (int i = 0; i < columnStrings.length; ++i) {
            columnTexts[i] = new Text(Base64.decodeBase64((byte[])columnStrings[i].getBytes()));
        }
        return columnTexts;
    }

    public static Text[] decodeTermValues(String terms) {
        String[] termStrings = terms.split("\n");
        Text[] termTexts = new Text[termStrings.length];
        for (int i = 0; i < termStrings.length; ++i) {
            termTexts[i] = new Text(Base64.decodeBase64((byte[])termStrings[i].getBytes()));
        }
        return termTexts;
    }

    public static boolean[] decodeBooleans(String flags) {
        if (flags == null) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((byte[])flags.getBytes());
        boolean[] bFlags = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bFlags[i] = bytes[i] == 1;
        }
        return bFlags;
    }

    protected Text getPartition(Key key) {
        return key.getRow();
    }

    protected Text getDataLocation(Key key) {
        return key.getColumnFamily();
    }

    protected Text getTerm(Key key) {
        int idx = 0;
        String sKey = key.getColumnQualifier().toString();
        idx = sKey.indexOf("\u0000");
        Text ret = new Text(sKey.substring(0, idx));
        return ret;
    }

    protected Text getDocID(Key key) {
        int idx = 0;
        String sKey = key.getColumnQualifier().toString();
        idx = sKey.indexOf("\u0000");
        return new Text(sKey.substring(idx + 1));
    }

    protected String getUID(Key key) {
        int idx = 0;
        String sKey = key.getColumnQualifier().toString();
        idx = sKey.indexOf("\u0000");
        return sKey.substring(idx + 1);
    }

    protected Key buildKey(Text row, Text dataLocation) {
        return new Key(row, dataLocation == null ? this.nullText : dataLocation);
    }

    protected Key buildKey(Text row, Text dataLocation, Text term) {
        return new Key(row, dataLocation == null ? this.nullText : dataLocation, term == null ? this.nullText : term);
    }

    protected Key buildFollowingPartitionKey(Key key) {
        return key.followingKey(PartialKey.ROW);
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new AndIterator(this, env);
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.value;
    }

    public boolean hasTop() {
        return this.currentRow != null;
    }

    private boolean seekOneSource(TermSource ts) throws IOException {
        boolean advancedCursor;
        block44: {
            block45: {
                int docidCompare;
                Text docid;
                advancedCursor = false;
                while (true) {
                    Key seekKey;
                    if (!ts.iter.hasTop()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"The current iterator no longer has a top");
                        }
                        if (!ts.notFlag) {
                            this.currentRow = null;
                            return true;
                        }
                        break block44;
                    }
                    int endCompare = -1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Current topKey = " + ts.iter.getTopKey()));
                    }
                    if (this.overallRange.getEndKey() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"II.seekOneSource overallRange.getEndKey() != null");
                        }
                        endCompare = this.overallRange.getEndKey().getRow().compareTo((BinaryComparable)((Key)ts.iter.getTopKey()).getRow());
                        if (!this.overallRange.isEndKeyInclusive() && endCompare <= 0 || endCompare < 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"II.seekOneSource at the end of the tablet server");
                            }
                            this.currentRow = null;
                            return true;
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"II.seekOneSource overallRange.getEndKey() == null");
                    }
                    int partitionCompare = this.currentRow.compareTo((BinaryComparable)this.getPartition((Key)ts.iter.getTopKey()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Current partition: " + this.currentRow));
                    }
                    if (partitionCompare > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Need to seek to the current row");
                            log.debug((Object)("ts.dataLocation = " + ts.dataLocation.getBytes()));
                            log.debug((Object)("Term = " + new Text(ts.term + "\u0000" + this.currentDocID).getBytes()));
                        }
                        Key seekKey2 = this.buildKey(this.currentRow, ts.dataLocation, this.nullText);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Seeking to: " + seekKey2));
                        }
                        ts.iter.seek(new Range(seekKey2, true, null, false), ts.seekColumnFamilies, SEEK_INCLUSIVE);
                        continue;
                    }
                    if (partitionCompare < 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Went too far beyond the currentRow");
                        }
                        if (!ts.notFlag) {
                            this.currentRow.set(this.getPartition((Key)ts.iter.getTopKey()));
                            this.currentDocID.set(this.emptyByteArray);
                            advancedCursor = true;
                            continue;
                        }
                        break block44;
                    }
                    if (ts.dataLocation != null) {
                        int dataLocationCompare = ts.dataLocation.compareTo((BinaryComparable)this.getDataLocation((Key)ts.iter.getTopKey()));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Comparing dataLocations");
                            log.debug((Object)("dataLocation = " + ts.dataLocation));
                            log.debug((Object)("newDataLocation = " + this.getDataLocation((Key)ts.iter.getTopKey())));
                        }
                        if (dataLocationCompare > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Need to seek to the right dataLocation");
                            }
                            seekKey = this.buildKey(this.currentRow, ts.dataLocation, this.nullText);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Seeking to: " + seekKey));
                            }
                            ts.iter.seek(new Range(seekKey, true, null, false), ts.seekColumnFamilies, SEEK_INCLUSIVE);
                            if (ts.iter.hasTop()) continue;
                            this.currentRow = null;
                            return true;
                        }
                        if (dataLocationCompare < 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Went too far beyond the dataLocation");
                            }
                            if (endCompare == 0) {
                                this.currentRow = null;
                                return true;
                            }
                            if (!ts.notFlag) {
                                seekKey = this.buildFollowingPartitionKey((Key)ts.iter.getTopKey());
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Seeking to: " + seekKey));
                                }
                                ts.iter.seek(new Range(seekKey, true, null, false), ts.seekColumnFamilies, SEEK_INCLUSIVE);
                                if (ts.iter.hasTop()) continue;
                                this.currentRow = null;
                                return true;
                            }
                            break block44;
                        }
                    }
                    int termCompare = ts.term.compareTo((BinaryComparable)this.getTerm((Key)ts.iter.getTopKey()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("term = " + ts.term));
                        log.debug((Object)("newTerm = " + this.getTerm((Key)ts.iter.getTopKey())));
                    }
                    if (termCompare > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Need to seek to the right term");
                        }
                        seekKey = this.buildKey(this.currentRow, ts.dataLocation, new Text(ts.term + "\u0000"));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Seeking to: " + seekKey));
                        }
                        ts.iter.seek(new Range(seekKey, true, null, false), ts.seekColumnFamilies, SEEK_INCLUSIVE);
                        if (!ts.iter.hasTop()) {
                            this.currentRow = null;
                            return true;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("topKey after seeking to correct term: " + ts.iter.getTopKey()));
                        continue;
                    }
                    if (termCompare < 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"TERM: Need to jump to the next row");
                        }
                        if (endCompare == 0) {
                            this.currentRow = null;
                            return true;
                        }
                        if (!ts.notFlag) {
                            seekKey = this.buildFollowingPartitionKey((Key)ts.iter.getTopKey());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Using this key to find the next key: " + ts.iter.getTopKey()));
                                log.debug((Object)("Seeking to: " + seekKey));
                            }
                            ts.iter.seek(new Range(seekKey, true, null, false), ts.seekColumnFamilies, SEEK_INCLUSIVE);
                            if (!ts.iter.hasTop()) {
                                this.currentRow = null;
                                return true;
                            }
                            this.currentTerm = this.getTerm((Key)ts.iter.getTopKey());
                            continue;
                        }
                        break block44;
                    }
                    docid = this.getDocID((Key)ts.iter.getTopKey());
                    docidCompare = this.currentDocID.compareTo((BinaryComparable)docid);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Comparing DocIDs");
                        log.debug((Object)("currentDocID = " + this.currentDocID));
                        log.debug((Object)("docid = " + docid));
                    }
                    if (docidCompare <= 0) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Need to seek to the correct docid");
                    }
                    Key seekKey3 = this.buildKey(this.currentRow, ts.dataLocation, new Text(ts.term + "\u0000" + this.currentDocID));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Seeking to: " + seekKey3));
                    }
                    ts.iter.seek(new Range(seekKey3, true, null, false), ts.seekColumnFamilies, SEEK_INCLUSIVE);
                }
                if (docidCompare >= 0) break block45;
                if (ts.notFlag) break block44;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"We went too far, update the currentDocID to be the location of where were seek'ed to");
                }
                this.currentDocID.set(docid);
                advancedCursor = true;
                break block44;
            }
            this.currentTerm = this.getTerm((Key)ts.iter.getTopKey());
            if (log.isDebugEnabled()) {
                log.debug((Object)("currentTerm = " + this.currentTerm));
            }
            if (!ts.notFlag) break block44;
            this.sources[0].iter.next();
            advancedCursor = true;
        }
        return advancedCursor;
    }

    public void next() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In ModifiedIntersectingIterator.next()");
        }
        if (this.currentRow == null) {
            return;
        }
        this.sources[0].iter.next();
        this.advanceToIntersection();
        if (this.hasTop() && this.overallRange != null && !this.overallRange.contains(this.topKey)) {
            this.topKey = null;
        }
    }

    protected void advanceToIntersection() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In AndIterator.advanceToIntersection()");
        }
        boolean cursorChanged = true;
        block0: while (cursorChanged) {
            cursorChanged = false;
            for (TermSource ts : this.sources) {
                if (this.currentRow == null) {
                    this.topKey = null;
                    return;
                }
                if (!this.seekOneSource(ts)) continue;
                cursorChanged = true;
                continue block0;
            }
        }
        this.topKey = this.buildKey(this.currentRow, this.currentTerm, this.currentDocID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ModifiedIntersectingIterator: Got a match: " + this.topKey));
        }
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)"In AndIterator.init()");
        }
        Text[] dataLocations = AndIterator.decodeColumns(options.get(columnFamiliesOptionName));
        Text[] terms = AndIterator.decodeTermValues(options.get(termValuesOptionName));
        boolean[] notFlags = AndIterator.decodeBooleans(options.get(notFlagsOptionName));
        if (terms.length < 2) {
            throw new IllegalArgumentException("AndIterator requires two or more columns families");
        }
        if (notFlags == null) {
            notFlags = new boolean[terms.length];
            for (i = 0; i < terms.length; ++i) {
                notFlags[i] = false;
            }
        }
        if (notFlags[0]) {
            for (i = 1; i < notFlags.length; ++i) {
                if (notFlags[i]) continue;
                Text swap = new Text(terms[0]);
                terms[0].set(terms[i]);
                terms[i].set(swap);
                swap.set(dataLocations[0]);
                dataLocations[0].set(dataLocations[i]);
                dataLocations[i].set(swap);
                notFlags[0] = false;
                notFlags[i] = true;
                break;
            }
            if (notFlags[0]) {
                throw new IllegalArgumentException("AndIterator requires at least one column family without not");
            }
        }
        this.sources = new TermSource[dataLocations.length];
        for (i = 0; i < dataLocations.length; ++i) {
            this.sources[i] = new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), dataLocations[i], terms[i], notFlags[i]);
        }
        this.sourcesCount = dataLocations.length;
    }

    public void seek(Range range, Collection<ByteSequence> seekColumnFamilies, boolean inclusive) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In AndIterator.seek()");
            log.debug((Object)("AndIterator.seek Given range => " + range));
        }
        this.currentRow = new Text();
        this.currentDocID.set(this.emptyByteArray);
        this.doSeek(range);
    }

    private void doSeek(Range range) throws IOException {
        this.overallRange = new Range(range);
        if (range.getEndKey() != null && range.getEndKey().getRow() != null) {
            this.parentEndRow = range.getEndKey().getRow();
        }
        for (int i = 0; i < this.sourcesCount; ++i) {
            Text dataLocation;
            Text text = dataLocation = this.sources[i].dataLocation == null ? this.nullText : this.sources[i].dataLocation;
            if (range.getStartKey() != null) {
                Key sourceKey = range.getStartKey().getColumnFamily() != null ? this.buildKey(this.getPartition(range.getStartKey()), dataLocation, this.sources[i].term == null ? this.nullText : new Text(this.sources[i].term + "\u0000" + range.getStartKey().getColumnFamily())) : this.buildKey(this.getPartition(range.getStartKey()), dataLocation, this.sources[i].term == null ? this.nullText : this.sources[i].term);
                if (!range.isStartKeyInclusive()) {
                    sourceKey = sourceKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL);
                }
                this.sources[i].iter.seek(new Range(sourceKey, true, null, false), this.sources[i].seekColumnFamilies, SEEK_INCLUSIVE);
                continue;
            }
            this.sources[i].iter.seek(range, this.sources[i].seekColumnFamilies, SEEK_INCLUSIVE);
        }
        this.advanceToIntersection();
        if (this.hasTop() && this.overallRange != null && !this.overallRange.contains(this.topKey)) {
            this.topKey = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("doSeek, topKey is outside of overall range: " + this.overallRange));
            }
        }
    }

    public void addSource(SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env, Text term, boolean notFlag) {
        this.addSource(source, env, null, term, notFlag);
    }

    public void addSource(SortedKeyValueIterator<Key, Value> source, IteratorEnvironment env, Text dataLocation, Text term, boolean notFlag) {
        if (this.sources == null) {
            this.sources = new TermSource[1];
        } else {
            TermSource[] localSources = new TermSource[this.sources.length + 1];
            int currSource = 0;
            for (TermSource myTerm : this.sources) {
                localSources[currSource] = new TermSource(myTerm);
                ++currSource;
            }
            this.sources = localSources;
        }
        this.sources[this.sourcesCount] = new TermSource((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), dataLocation, term, notFlag);
        ++this.sourcesCount;
    }

    public boolean jump(Key jumpKey) throws IOException {
        int ucomp;
        if (log.isDebugEnabled()) {
            log.debug((Object)("jump: " + jumpKey));
        }
        if (this.parentEndRow != null && this.parentEndRow.compareTo((BinaryComparable)jumpKey.getRow()) < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("jumpRow: " + jumpKey.getRow() + " is greater than my parentEndRow: " + this.parentEndRow));
            }
            return false;
        }
        if (!this.hasTop()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"jump called, but topKey is null, must need to move to next row");
            }
            return false;
        }
        int comp = this.topKey.getRow().compareTo((BinaryComparable)jumpKey.getRow());
        if (comp > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"jump, our row is ahead of jumpKey.");
                log.debug((Object)("jumpRow: " + jumpKey.getRow() + " myRow: " + this.topKey.getRow() + " parentEndRow" + this.parentEndRow));
            }
            return this.hasTop();
        }
        if (comp < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"II jump, row jump");
            }
            Key endKey = null;
            if (this.parentEndRow != null) {
                endKey = new Key(this.parentEndRow);
            }
            Key sKey = new Key(jumpKey.getRow());
            Range fake = new Range(sKey, true, endKey, false);
            this.seek(fake, null, false);
            return this.hasTop();
        }
        String myUid = this.topKey.getColumnQualifier().toString();
        String jumpUid = this.getUID(jumpKey);
        if (log.isDebugEnabled()) {
            if (myUid == null) {
                log.debug((Object)"myUid is null");
            } else {
                log.debug((Object)("myUid: " + myUid));
            }
            if (jumpUid == null) {
                log.debug((Object)"jumpUid is null");
            } else {
                log.debug((Object)("jumpUid: " + jumpUid));
            }
        }
        if ((ucomp = myUid.compareTo(jumpUid)) < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"jump, uid jump");
            }
            Text row = jumpKey.getRow();
            Range range = new Range(row);
            this.currentRow = row;
            this.currentDocID = new Text(this.getUID(jumpKey));
            this.doSeek(range);
            if (this.hasTop() && this.parentEndRow != null && this.topKey.getRow().compareTo((BinaryComparable)this.parentEndRow) > 0) {
                this.topKey = null;
            }
            if (log.isDebugEnabled() && this.hasTop()) {
                log.debug((Object)("jump, topKey is now: " + this.topKey));
            }
            return this.hasTop();
        }
        if (this.hasTop() && this.parentEndRow != null && this.topKey.getRow().compareTo((BinaryComparable)this.parentEndRow) > 0) {
            this.topKey = null;
        }
        return this.hasTop();
    }

    protected static class TermSource {
        public SortedKeyValueIterator<Key, Value> iter;
        public Text dataLocation;
        public Text term;
        public boolean notFlag;
        private Collection<ByteSequence> seekColumnFamilies;

        private TermSource(TermSource other) {
            this(other.iter, other.dataLocation, other.term, other.notFlag);
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text dataLocation, Text term) {
            this(iter, dataLocation, term, false);
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text dataLocation, Text term, boolean notFlag) {
            this.iter = iter;
            this.dataLocation = dataLocation;
            ArrayByteSequence bs = new ArrayByteSequence(dataLocation.getBytes(), 0, dataLocation.getLength());
            this.seekColumnFamilies = Collections.singletonList(bs);
            this.term = term;
            this.notFlag = notFlag;
        }

        public String getTermString() {
            return this.term == null ? new String("Iterator") : this.term.toString();
        }
    }
}

