/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.jexl2.parser.ASTAndNode;
import org.apache.commons.jexl2.parser.ASTEQNode;
import org.apache.commons.jexl2.parser.ASTERNode;
import org.apache.commons.jexl2.parser.ASTGENode;
import org.apache.commons.jexl2.parser.ASTGTNode;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.ASTLENode;
import org.apache.commons.jexl2.parser.ASTLTNode;
import org.apache.commons.jexl2.parser.ASTNENode;
import org.apache.commons.jexl2.parser.ASTNRNode;
import org.apache.commons.jexl2.parser.ASTNotNode;
import org.apache.commons.jexl2.parser.ASTOrNode;
import org.apache.commons.jexl2.parser.ParseException;
import org.apache.commons.jexl2.parser.ParserTreeConstants;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.AndIterator;
import org.calrissian.accumulorecipes.commons.iterators.DefaultIteratorEnvironment;
import org.calrissian.accumulorecipes.commons.iterators.FieldIndexIterator;
import org.calrissian.accumulorecipes.commons.iterators.OrIterator;
import org.calrissian.accumulorecipes.commons.iterators.UniqFieldNameValueIterator;
import org.calrissian.accumulorecipes.commons.iterators.support.BooleanLogicTreeNode;
import org.calrissian.accumulorecipes.commons.iterators.support.FieldIndexKeyParser;
import org.calrissian.accumulorecipes.commons.iterators.support.JexlOperatorConstants;
import org.calrissian.accumulorecipes.commons.iterators.support.QueryParser;
import org.calrissian.accumulorecipes.commons.iterators.support.RangeCalculator;
import org.calrissian.accumulorecipes.commons.iterators.support.TreeNode;

public class BooleanLogicIterator
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    public static final String QUERY_OPTION = "expr";
    public static final String TERM_CARDINALITIES = "TERM_CARDINALITIES";
    public static final String FIELD_INDEX_QUERY = "FIELD_INDEX_QUERY";
    public static final String FIELD_NAME_PREFIX = "fi\u0000";
    protected static final Logger log = Logger.getLogger(BooleanLogicIterator.class);
    private static final Collection<ByteSequence> EMPTY_COL_FAMS = new ArrayList<ByteSequence>();
    private static IteratorEnvironment env = new DefaultIteratorEnvironment();
    protected Text nullText = new Text();
    boolean initfailed = false;
    private Key topKey = null;
    private Value topValue = null;
    private SortedKeyValueIterator<Key, Value> sourceIterator;
    private BooleanLogicTreeNode root;
    private PriorityQueue<BooleanLogicTreeNode> positives;
    private ArrayList<BooleanLogicTreeNode> negatives = new ArrayList();
    private ArrayList<BooleanLogicTreeNode> rangerators;
    private String updatedQuery;
    private Map<String, Long> termCardinalities = new HashMap<String, Long>();
    private Range overallRange = null;
    private FieldIndexKeyParser keyParser;

    public BooleanLogicIterator() {
        this.keyParser = new FieldIndexKeyParser();
        this.rangerators = new ArrayList();
    }

    public BooleanLogicIterator(BooleanLogicIterator other, IteratorEnvironment env) {
        if (other.sourceIterator != null) {
            this.sourceIterator = other.sourceIterator.deepCopy(env);
        }
        this.keyParser = new FieldIndexKeyParser();
        this.rangerators = new ArrayList();
        log.debug((Object)"Congratulations, you've reached the BooleanLogicIterator");
    }

    public static void setLogLevel(Level lev) {
        log.setLevel(lev);
    }

    public static void collapseBranches(BooleanLogicTreeNode myroot) throws Exception {
        ArrayList<BooleanLogicTreeNode> nodes = new ArrayList<BooleanLogicTreeNode>();
        Enumeration<javax.swing.tree.TreeNode> bfe = myroot.breadthFirstEnumeration();
        while (bfe.hasMoreElements()) {
            BooleanLogicTreeNode node = (BooleanLogicTreeNode)bfe.nextElement();
            nodes.add(node);
        }
        for (int i = nodes.size() - 1; i >= 0; --i) {
            BooleanLogicTreeNode node = (BooleanLogicTreeNode)nodes.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("collapseBranches, inspecting node: " + node.toString() + "  " + node.printNode()));
            }
            if (node.getType() == 10 || node.getType() == 9) {
                if (node.getChildCount() == 0 && !node.isRangeNode()) {
                    node.removeFromParent();
                    continue;
                }
                if (node.getChildCount() != 1) continue;
                BooleanLogicTreeNode p = (BooleanLogicTreeNode)node.getParent();
                BooleanLogicTreeNode c = (BooleanLogicTreeNode)node.getFirstChild();
                node.removeFromParent();
                p.add(c);
                continue;
            }
            if (node.getType() != 0 || node.getChildCount() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"collapseBranches, headNode has no children");
            }
            throw new Exception("Head node has no children.");
        }
    }

    private static boolean canRollUp(BooleanLogicTreeNode parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("canRollUp: testing " + parent.getContents()));
        }
        if (parent.getChildCount() < 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"canRollUp: child count < 1, return false");
            }
            return false;
        }
        Enumeration<javax.swing.tree.TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            BooleanLogicTreeNode child = (BooleanLogicTreeNode)e.nextElement();
            if (child.getType() != 14) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("canRollUp: child.getType -> " + ParserTreeConstants.jjtNodeName[child.getType()] + " int: " + child.getType() + "  return false"));
                }
                return false;
            }
            if (child.isNegated()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"canRollUp: child.isNegated, return false");
                }
                return false;
            }
            if (!child.getFieldValue().toString().contains("*")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("canRollUp: child has wildcard: " + child.getFieldValue()));
            }
            return false;
        }
        return true;
    }

    public static void showDepthFirstTraversal(BooleanLogicTreeNode root) {
        System.out.println("DepthFirstTraversal");
        Enumeration<javax.swing.tree.TreeNode> e = root.depthFirstEnumeration();
        int i = -1;
        while (e.hasMoreElements()) {
            BooleanLogicTreeNode n = (BooleanLogicTreeNode)e.nextElement();
            System.out.println(++i + " : " + n);
        }
    }

    public static void showBreadthFirstTraversal(BooleanLogicTreeNode root) {
        System.out.println("BreadthFirstTraversal");
        log.debug((Object)"BooleanLogicIterator.showBreadthFirstTraversal()");
        Enumeration<javax.swing.tree.TreeNode> e = root.breadthFirstEnumeration();
        int i = -1;
        while (e.hasMoreElements()) {
            BooleanLogicTreeNode n = (BooleanLogicTreeNode)e.nextElement();
            System.out.println(++i + " : " + n);
            log.debug((Object)(i + " : " + n));
        }
    }

    public void setDebug(Level lev) {
        log.setLevel(lev);
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new BooleanLogicIterator(this, env);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.validateOptions(options);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Congratulations, you've reached the BooleanLogicIterator.init method");
            }
            this.sourceIterator = source.deepCopy(env);
            String[] terms = null;
            if (null != options.get(TERM_CARDINALITIES)) {
                for (String term : terms = options.get(TERM_CARDINALITIES).split(",")) {
                    int idx = term.indexOf(":");
                    if (-1 == idx) continue;
                    this.termCardinalities.put(term.substring(0, idx), Long.parseLong(term.substring(idx + 1)));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"QueryParser");
            }
            QueryParser qp = new QueryParser();
            qp.execute(this.updatedQuery);
            if (log.isDebugEnabled()) {
                log.debug((Object)"transformTreeNode");
            }
            TreeNode tree = qp.getIteratorTree();
            this.root = this.transformTreeNode(tree);
            if (log.isDebugEnabled()) {
                log.debug((Object)"refactorTree");
            }
            this.root = this.refactorTree(this.root);
            if (log.isDebugEnabled()) {
                log.debug((Object)"collapseBranches");
            }
            BooleanLogicIterator.collapseBranches(this.root);
            this.createIteratorTree(this.root);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Query tree after iterator creation:\n\t" + this.root.getContents()));
            }
            this.splitLeaves(this.root);
        }
        catch (ParseException ex) {
            log.error((Object)("ParseException in init: " + (Object)((Object)ex)));
            throw new IllegalArgumentException("Failed to parse criteria", ex);
        }
        catch (Exception ex) {
            this.initfailed = true;
        }
    }

    private void createIteratorTree(BooleanLogicTreeNode root) throws IOException {
        BooleanLogicTreeNode node;
        if (log.isDebugEnabled()) {
            log.debug((Object)"BoolLogic createIteratorTree()");
        }
        Enumeration<javax.swing.tree.TreeNode> dfe = root.depthFirstEnumeration();
        while (dfe.hasMoreElements()) {
            node = (BooleanLogicTreeNode)dfe.nextElement();
            if (node.isLeaf() || node.getType() == 0 || !BooleanLogicIterator.canRollUp(node)) continue;
            node.setRollUp(true);
            if (node.getType() == 10) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"creating IntersectingIterator");
                }
                node.setUserObject(this.createIntersectingIterator(node));
            } else if (node.getType() == 9) {
                node.setUserObject(this.createOrIterator(node));
            } else {
                log.debug((Object)("createIteratorTree, encounterd a node type I do not know about: " + node.getType()));
                log.debug((Object)("createIteratorTree, node contents:  " + node.getContents()));
            }
            node.removeAllChildren();
        }
        dfe = root.depthFirstEnumeration();
        while (dfe.hasMoreElements()) {
            node = (BooleanLogicTreeNode)dfe.nextElement();
            if (!node.isLeaf() || node.getType() == 10 || node.getType() == 9) continue;
            node.setUserObject((Object)this.createFieldIndexIterator(node));
        }
    }

    private AndIterator createIntersectingIterator(BooleanLogicTreeNode node) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createIntersectingIterator(node)");
            log.debug((Object)("fName: " + node.getFieldName() + " , fValue: " + node.getFieldValue() + " , operator: " + node.getFieldOperator()));
        }
        Text[] columnFamilies = new Text[node.getChildCount()];
        Text[] termValues = new Text[node.getChildCount()];
        boolean[] negationMask = new boolean[node.getChildCount()];
        Enumeration<javax.swing.tree.TreeNode> children = node.children();
        int i = 0;
        while (children.hasMoreElements()) {
            BooleanLogicTreeNode child = (BooleanLogicTreeNode)children.nextElement();
            columnFamilies[i] = child.getFieldName();
            termValues[i] = child.getFieldValue();
            negationMask[i] = child.isNegated();
            ++i;
        }
        AndIterator ii = new AndIterator();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("columnFamilies", AndIterator.encodeColumns(columnFamilies));
        options.put("termValues", AndIterator.encodeTermValues(termValues));
        options.put("notFlags", AndIterator.encodeBooleans(negationMask));
        ii.init((SortedKeyValueIterator<Key, Value>)this.sourceIterator.deepCopy(env), options, env);
        return ii;
    }

    private OrIterator createOrIterator(BooleanLogicTreeNode node) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createOrIterator(node)");
            log.debug((Object)("fName: " + node.getFieldName() + " , fValue: " + node.getFieldValue() + " , operator: " + node.getFieldOperator()));
        }
        Enumeration<javax.swing.tree.TreeNode> children = node.children();
        ArrayList<Text> fams = new ArrayList<Text>();
        ArrayList<Text> quals = new ArrayList<Text>();
        while (children.hasMoreElements()) {
            BooleanLogicTreeNode child = (BooleanLogicTreeNode)children.nextElement();
            fams.add(child.getFieldName());
            quals.add(child.getFieldValue());
        }
        OrIterator iter = new OrIterator();
        SortedKeyValueIterator source = this.sourceIterator.deepCopy(env);
        for (int i = 0; i < fams.size(); ++i) {
            iter.addTerm((SortedKeyValueIterator<Key, Value>)source, (Text)fams.get(i), (Text)quals.get(i), env);
        }
        return iter;
    }

    private FieldIndexIterator createFieldIndexIterator(BooleanLogicTreeNode node) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"BoolLogic.createFieldIndexIterator()");
            log.debug((Object)("fName: " + node.getFieldName() + " , fValue: " + node.getFieldValue() + " , operator: " + node.getFieldOperator()));
        }
        Text rowId = null;
        this.sourceIterator.seek(new Range(), EMPTY_COL_FAMS, false);
        if (this.sourceIterator.hasTop()) {
            rowId = ((Key)this.sourceIterator.getTopKey()).getRow();
        }
        FieldIndexIterator iter = new FieldIndexIterator(node.getType(), rowId, node.getFieldName(), node.getFieldValue(), node.isNegated(), node.getFieldOperator());
        HashMap options = new HashMap();
        iter.init(this.sourceIterator.deepCopy(env), options, env);
        if (log.isDebugEnabled()) {
            FieldIndexIterator.setLogLevel(Level.DEBUG);
        } else {
            FieldIndexIterator.setLogLevel(Level.OFF);
        }
        return iter;
    }

    private boolean testTreeState() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"BoolLogic testTreeState() begin");
        }
        Enumeration<javax.swing.tree.TreeNode> dfe = this.root.depthFirstEnumeration();
        while (dfe.hasMoreElements()) {
            BooleanLogicTreeNode node = (BooleanLogicTreeNode)dfe.nextElement();
            if (!node.isLeaf()) {
                int type = node.getType();
                if (type == 10) {
                    this.handleAND(node);
                    continue;
                }
                if (type == 9) {
                    this.handleOR(node);
                    continue;
                }
                if (type == 0) {
                    this.handleHEAD(node);
                    continue;
                }
                if (type != 29) continue;
            }
            if (node.getType() == 9) {
                node.setValid(node.hasTop());
                node.reSet();
                node.addToSet(node.getTopKey());
                continue;
            }
            if (node.getType() != 10 && node.getType() != 14 && node.getType() != 20 && node.getType() != 18 && node.getType() != 16 && node.getType() != 19 && node.getType() != 17) continue;
            node.setValid(node.hasTop());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BoolLogic.testTreeState end, treeState:: " + this.root.getContents() + "  , valid: " + this.root.isValid()));
        }
        return this.root.isValid();
    }

    private void handleHEAD(BooleanLogicTreeNode node) {
        Enumeration<javax.swing.tree.TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            BooleanLogicTreeNode child = (BooleanLogicTreeNode)children.nextElement();
            if (child.getType() == 10) {
                node.setValid(child.isValid());
                node.setTopKey(child.getTopKey());
                continue;
            }
            if (child.getType() == 9) {
                node.setValid(child.isValid());
                node.setTopKey(child.getTopKey());
                continue;
            }
            if (child.getType() != 14 && child.getType() != 20 && child.getType() != 17 && child.getType() != 19 && child.getType() != 16 && child.getType() != 18) continue;
            node.setValid(true);
            node.setTopKey(child.getTopKey());
            if (child.getTopKey() != null) continue;
            node.setValid(false);
        }
        if (node.isValid() && !node.hasTop()) {
            node.setValid(false);
        }
    }

    private void handleAND(BooleanLogicTreeNode me) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleAND::" + me.getContents()));
        }
        Enumeration<javax.swing.tree.TreeNode> children = me.children();
        me.setValid(true);
        HashSet<Key> goodSet = new HashSet<Key>();
        HashSet<Key> badSet = new HashSet<Key>();
        while (children.hasMoreElements()) {
            BooleanLogicTreeNode child = (BooleanLogicTreeNode)children.nextElement();
            if (child.getType() == 14 || child.getType() == 10 || child.getType() == 20 || child.getType() == 15 || child.getType() == 19 || child.getType() == 18 || child.getType() == 17 || child.getType() == 16) {
                if (child.isNegated()) {
                    if (!child.hasTop()) continue;
                    badSet.add(child.getTopKey());
                    if (goodSet.contains(child.getTopKey())) {
                        me.setValid(false);
                        return;
                    }
                    if (!child.isValid()) continue;
                    me.setValid(false);
                    return;
                }
                if (child.hasTop()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("handleAND, child node: " + child.getContents()));
                    }
                    if (badSet.contains(child.getTopKey())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"handleAND, child is in bad set, setting parent false");
                        }
                        me.setValid(false);
                        return;
                    }
                    if (goodSet.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("handleAND, goodSet is empty, adding child: " + child.getContents()));
                        }
                        goodSet.add(child.getTopKey());
                        continue;
                    }
                    if (!goodSet.contains(child.getTopKey())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("handleAND, goodSet is not empty, and does NOT contain child, setting false.  child: " + child.getContents()));
                        }
                        me.setValid(false);
                        return;
                    }
                    goodSet = new HashSet();
                    goodSet.add(child.getTopKey());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("handleAND, child in goodset, trim to this value: " + child.getContents()));
                    continue;
                }
                if (child.getChildCount() > 0) {
                    Enumeration<javax.swing.tree.TreeNode> subchildren = child.children();
                    boolean allFalse = true;
                    while (subchildren.hasMoreElements()) {
                        BooleanLogicTreeNode subchild = (BooleanLogicTreeNode)subchildren.nextElement();
                        if (!subchild.isNegated()) {
                            allFalse = false;
                            break;
                        }
                        if (!subchild.isNegated() || !subchild.hasTop()) continue;
                        allFalse = false;
                        break;
                    }
                    if (allFalse) continue;
                    me.setValid(false);
                    return;
                }
                me.setValid(false);
                return;
            }
            if (child.getType() != 9) continue;
            Iterator<Key> iter = child.getSetIterator();
            boolean goodSetEmpty = goodSet.isEmpty();
            boolean matchedOne = false;
            boolean pureNegations = true;
            if (!child.isValid()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("handleAND, child is an OR and it is not valid, setting false, ALL NEGATED?: " + child.isChildrenAllNegated()));
                }
                me.setValid(false);
                return;
            }
            if ((!child.isValid() || child.hasTop()) && child.isValid() && child.hasTop()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"handleAND, child OR, valid and has top, means not pureNegations");
                }
                pureNegations = false;
                while (iter.hasNext()) {
                    Key i = iter.next();
                    if (child.isNegated()) {
                        badSet.add(i);
                        if (!goodSet.contains(i)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("handleAND, child OR, goodSet contains bad value: " + i));
                        }
                        me.setValid(false);
                        return;
                    }
                    if (goodSetEmpty && !badSet.contains(i)) {
                        goodSet.add(i);
                        matchedOne = true;
                        continue;
                    }
                    if (!goodSet.contains(i)) continue;
                    matchedOne = true;
                }
            }
            if (child.isNegated()) continue;
            if (goodSet.isEmpty() && !pureNegations) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"handleAND, child OR, empty goodset && !pureNegations, set false");
                }
                me.setValid(false);
                return;
            }
            if (goodSet.isEmpty() || pureNegations) continue;
            if (!matchedOne) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"handleAND, child OR, goodSet had values but I didn't match any, false");
                }
                me.setValid(false);
                return;
            }
            goodSet = child.getIntersection(goodSet);
        }
        if (goodSet.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"handleAND-> goodSet is empty, pure negations?");
            }
        } else {
            me.setTopKey((Key)Collections.min(goodSet));
            if (log.isDebugEnabled()) {
                log.debug((Object)("End of handleAND, this node's topKey: " + me.getTopKey()));
            }
        }
    }

    private void handleOR(BooleanLogicTreeNode me) {
        BooleanLogicTreeNode child;
        Enumeration<javax.swing.tree.TreeNode> children = me.children();
        me.setValid(false);
        me.reSet();
        me.setTopKey(null);
        boolean allNegated = true;
        while (children.hasMoreElements()) {
            child = (BooleanLogicTreeNode)children.nextElement();
            if (child.getType() == 14 || child.getType() == 15 || child.getType() == 10 || child.getType() == 20 || child.getType() == 21 || child.getType() == 18 || child.getType() == 16 || child.getType() == 19 || child.getType() == 17) {
                if (child.hasTop()) {
                    if (child.isNegated()) continue;
                    allNegated = false;
                    if (!child.isValid()) continue;
                    me.addToSet(child.getTopKey());
                    continue;
                }
                if (child.isNegated()) continue;
                allNegated = false;
                me.setValid(child.isValid());
                continue;
            }
            if (child.getType() != 9) continue;
            if (child.hasTop()) {
                if (child.isNegated()) continue;
                allNegated = false;
                Iterator<Key> iter = child.getSetIterator();
                while (iter.hasNext()) {
                    Key i = iter.next();
                    if (i == null) continue;
                    me.addToSet(i);
                }
                continue;
            }
            if (!child.isValid()) continue;
            me.setValid(true);
        }
        if (allNegated) {
            children = me.children();
            while (children.hasMoreElements()) {
                child = (BooleanLogicTreeNode)children.nextElement();
                if (child.hasTop()) continue;
                me.setValid(true);
                me.setTopKey(null);
                return;
            }
            me.setValid(false);
        } else {
            Key k = me.getMinUniqueID();
            if (k == null) {
                me.setValid(false);
            } else {
                me.setValid(true);
                me.setTopKey(k);
            }
        }
    }

    public BooleanLogicTreeNode transformTreeNode(TreeNode node) throws ParseException {
        Collection values;
        Multimap<String, QueryParser.QueryTerm> terms;
        Collection values2;
        Multimap<String, QueryParser.QueryTerm> terms2;
        if (node.getType().equals(ASTEQNode.class) || node.getType().equals(ASTNENode.class)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Equals Node");
            }
            terms2 = node.getTerms();
            for (String fName : terms2.keySet()) {
                values2 = terms2.get((Object)fName);
                for (QueryParser.QueryTerm t : values2) {
                    if (null == t || null == t.getValue()) continue;
                    String fValue = t.getValue().toString();
                    fValue = fValue.replaceAll("'", "");
                    boolean negated = t.getOperator().equals("!=");
                    if (!fName.startsWith(FIELD_NAME_PREFIX)) {
                        fName = FIELD_NAME_PREFIX + fName;
                    }
                    BooleanLogicTreeNode child = new BooleanLogicTreeNode(14, fName, fValue, negated);
                    return child;
                }
            }
        }
        if (node.getType().equals(ASTERNode.class) || node.getType().equals(ASTNRNode.class)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Regex Node");
            }
            terms2 = node.getTerms();
            for (String fName : terms2.keySet()) {
                values2 = terms2.get((Object)fName);
                for (QueryParser.QueryTerm t : values2) {
                    if (null == t || null == t.getValue()) continue;
                    String fValue = t.getValue().toString();
                    fValue = fValue.replaceAll("'", "");
                    boolean negated = node.getType().equals(ASTNRNode.class);
                    if (!fName.startsWith(FIELD_NAME_PREFIX)) {
                        fName = FIELD_NAME_PREFIX + fName;
                    }
                    BooleanLogicTreeNode child = new BooleanLogicTreeNode(20, fName, fValue, negated);
                    return child;
                }
            }
        }
        if (node.getType().equals(ASTLTNode.class) || node.getType().equals(ASTLENode.class) || node.getType().equals(ASTGTNode.class) || node.getType().equals(ASTGENode.class)) {
            terms2 = node.getTerms();
            for (String fName : terms2.keySet()) {
                values2 = terms2.get((Object)fName);
                if (!fName.startsWith(FIELD_NAME_PREFIX)) {
                    fName = FIELD_NAME_PREFIX + fName;
                }
                for (QueryParser.QueryTerm t : values2) {
                    if (null == t || null == t.getValue()) continue;
                    String fValue = t.getValue().toString();
                    fValue = fValue.replaceAll("'", "");
                    boolean negated = false;
                    int mytype = JexlOperatorConstants.getJJTNodeType(t.getOperator());
                    BooleanLogicTreeNode child = new BooleanLogicTreeNode(mytype, fName, fValue, negated);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding child node: " + child.getContents()));
                    }
                    return child;
                }
            }
        }
        BooleanLogicTreeNode returnNode = null;
        if (node.getType().equals(ASTAndNode.class) || node.getType().equals(ASTOrNode.class)) {
            int parentType;
            int n = parentType = node.getType().equals(ASTAndNode.class) ? 10 : 9;
            if (log.isDebugEnabled()) {
                log.debug((Object)("AND/OR node: " + parentType));
            }
            if (node.isLeaf() || !node.getTerms().isEmpty()) {
                returnNode = new BooleanLogicTreeNode(parentType);
                Multimap<String, QueryParser.QueryTerm> terms3 = node.getTerms();
                for (String fName : terms3.keySet()) {
                    Collection values3 = terms3.get((Object)fName);
                    if (!fName.startsWith(FIELD_NAME_PREFIX)) {
                        fName = FIELD_NAME_PREFIX + fName;
                    }
                    for (QueryParser.QueryTerm t : values3) {
                        if (null == t || null == t.getValue()) continue;
                        String fValue = t.getValue().toString();
                        fValue = fValue.replaceAll("'", "");
                        boolean negated = t.getOperator().equals("!=");
                        int mytype = JexlOperatorConstants.getJJTNodeType(t.getOperator());
                        BooleanLogicTreeNode child = new BooleanLogicTreeNode(mytype, fName, fValue, negated);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("adding child node: " + child.getContents()));
                        }
                        returnNode.add(child);
                    }
                }
            } else {
                returnNode = new BooleanLogicTreeNode(parentType);
            }
        } else if (node.getType().equals(ASTNotNode.class)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"NOT node");
            }
            if (node.isLeaf()) {
                terms = node.getTerms();
                for (String fName : terms.keySet()) {
                    values = terms.get((Object)fName);
                    if (!fName.startsWith(FIELD_NAME_PREFIX)) {
                        fName = FIELD_NAME_PREFIX + fName;
                    }
                    for (QueryParser.QueryTerm t : values) {
                        if (null == t || null == t.getValue()) continue;
                        String fValue = t.getValue().toString();
                        fValue = fValue.replaceAll("'", "");
                        boolean negated = !t.getOperator().equals("!=");
                        int mytype = JexlOperatorConstants.getJJTNodeType(t.getOperator());
                        if (!fName.startsWith(FIELD_NAME_PREFIX)) {
                            fName = FIELD_NAME_PREFIX + fName;
                        }
                        return new BooleanLogicTreeNode(mytype, fName, fValue, negated);
                    }
                }
            } else {
                returnNode = new BooleanLogicTreeNode(29);
            }
        } else if (node.getType().equals(ASTJexlScript.class) || node.getType().getSimpleName().equals("RootNode")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ROOT/JexlScript node");
            }
            if (node.isLeaf()) {
                returnNode = new BooleanLogicTreeNode(0);
                terms = node.getTerms();
                for (String fName : terms.keySet()) {
                    values = terms.get((Object)fName);
                    if (!fName.startsWith(FIELD_NAME_PREFIX)) {
                        fName = FIELD_NAME_PREFIX + fName;
                    }
                    for (QueryParser.QueryTerm t : values) {
                        if (null == t || null == t.getValue()) continue;
                        String fValue = t.getValue().toString();
                        fValue = fValue.replaceAll("'", "");
                        boolean negated = t.getOperator().equals("!=");
                        int mytype = JexlOperatorConstants.getJJTNodeType(t.getOperator());
                        BooleanLogicTreeNode child = new BooleanLogicTreeNode(mytype, fName, fValue, negated);
                        returnNode.add(child);
                        return returnNode;
                    }
                }
            } else {
                returnNode = new BooleanLogicTreeNode(0);
            }
        } else {
            log.error((Object)("Currently Unsupported Node type: " + node.getClass().getName() + " \t" + node.getType()));
        }
        for (TreeNode child : node.getChildren()) {
            returnNode.add(this.transformTreeNode(child));
        }
        return returnNode;
    }

    public BooleanLogicTreeNode refactorTree(BooleanLogicTreeNode myroot) {
        ArrayList<BooleanLogicTreeNode> nodes = new ArrayList<BooleanLogicTreeNode>();
        Enumeration<javax.swing.tree.TreeNode> bfe = myroot.breadthFirstEnumeration();
        while (bfe.hasMoreElements()) {
            BooleanLogicTreeNode node = (BooleanLogicTreeNode)bfe.nextElement();
            nodes.add(node);
        }
        for (int i = nodes.size() - 1; i >= 0; --i) {
            BooleanLogicTreeNode node = (BooleanLogicTreeNode)nodes.get(i);
            if (node.getType() != 10 && node.getType() != 9) continue;
            HashMap<Text, RangeCalculator.RangeBounds> ranges = new HashMap<Text, RangeCalculator.RangeBounds>();
            Enumeration<javax.swing.tree.TreeNode> children = node.children();
            boolean allNegated = true;
            while (children.hasMoreElements()) {
                RangeCalculator.RangeBounds rb;
                BooleanLogicTreeNode child = (BooleanLogicTreeNode)children.nextElement();
                if (!child.isNegated()) {
                    allNegated = false;
                }
                if (node.getType() != 10) continue;
                if (child.getType() == 17) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("refactor: GT " + child.getContents()));
                    }
                    if (ranges.containsKey(child.getFieldName())) {
                        rb = (RangeCalculator.RangeBounds)ranges.get(child.getFieldName());
                        rb.setLower(child.getFieldValue());
                        continue;
                    }
                    rb = new RangeCalculator.RangeBounds();
                    rb.setLower(child.getFieldValue());
                    ranges.put(child.getFieldName(), rb);
                    continue;
                }
                if (child.getType() == 19) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("refactor: GE " + child.getContents()));
                    }
                    if (ranges.containsKey(child.getFieldName())) {
                        rb = (RangeCalculator.RangeBounds)ranges.get(child.getFieldName());
                        rb.setLower(child.getFieldValue());
                        continue;
                    }
                    rb = new RangeCalculator.RangeBounds();
                    rb.setLower(child.getFieldValue());
                    ranges.put(child.getFieldName(), rb);
                    continue;
                }
                if (child.getType() == 16) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("refactor: LT " + child.getContents()));
                    }
                    if (ranges.containsKey(child.getFieldName())) {
                        rb = (RangeCalculator.RangeBounds)ranges.get(child.getFieldName());
                        rb.setUpper(child.getFieldValue());
                        continue;
                    }
                    rb = new RangeCalculator.RangeBounds();
                    rb.setUpper(child.getFieldValue());
                    ranges.put(child.getFieldName(), rb);
                    continue;
                }
                if (child.getType() != 18) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("refactor: LE " + child.getContents()));
                }
                if (ranges.containsKey(child.getFieldName())) {
                    rb = (RangeCalculator.RangeBounds)ranges.get(child.getFieldName());
                    rb.setUpper(child.getFieldValue());
                    continue;
                }
                rb = new RangeCalculator.RangeBounds();
                rb.setUpper(child.getFieldValue());
                ranges.put(child.getFieldName(), rb);
            }
            if (allNegated) {
                node.setChildrenAllNegated(true);
            }
            if (node.getType() != 10 || ranges.isEmpty()) continue;
            if (node.getChildCount() <= 2 && ranges.size() == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"AND range 2 children or less");
                }
                node.setType(9);
                node.removeAllChildren();
                for (Map.Entry entry : ranges.entrySet()) {
                    Text fName = (Text)entry.getKey();
                    RangeCalculator.RangeBounds rb = (RangeCalculator.RangeBounds)entry.getValue();
                    node.setFieldName(fName);
                    node.setFieldValue(new Text(""));
                    node.setLowerBound(rb.getLower());
                    node.setUpperBound(rb.getUpper());
                    node.setRangeNode(true);
                }
                this.rangerators.add(node);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("refactor: " + node.getContents()));
                log.debug((Object)("refactor: " + node.getLowerBound() + "  " + node.getUpperBound()));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"AND range more than 2 children");
            }
            ArrayList<BooleanLogicTreeNode> temp = new ArrayList<BooleanLogicTreeNode>();
            Enumeration<javax.swing.tree.TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                BooleanLogicTreeNode c = (BooleanLogicTreeNode)e.nextElement();
                temp.add(c);
            }
            for (int j = temp.size() - 1; j >= 0; --j) {
                BooleanLogicTreeNode c = (BooleanLogicTreeNode)temp.get(j);
                if (c.getType() != 18 && c.getType() != 16 && c.getType() != 19 && c.getType() != 17) continue;
                c.removeFromParent();
            }
            for (Map.Entry entry : ranges.entrySet()) {
                Text fName = (Text)entry.getKey();
                BooleanLogicTreeNode nchild = new BooleanLogicTreeNode(9, fName.toString(), "");
                RangeCalculator.RangeBounds rb = (RangeCalculator.RangeBounds)entry.getValue();
                nchild.setFieldValue(new Text(""));
                nchild.setLowerBound(rb.getLower());
                nchild.setUpperBound(rb.getUpper());
                nchild.setRangeNode(true);
                node.add(nchild);
                this.rangerators.add(nchild);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("refactor: " + node.getContents()));
        }
        return myroot;
    }

    private void splitLeaves(BooleanLogicTreeNode node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"BoolLogic: splitLeaves()");
        }
        this.positives = new PriorityQueue<Object>(10, new BooleanLogicTreeNodeComparator());
        this.negatives.clear();
        Enumeration<javax.swing.tree.TreeNode> dfe = node.depthFirstEnumeration();
        while (dfe.hasMoreElements()) {
            BooleanLogicTreeNode elem = (BooleanLogicTreeNode)dfe.nextElement();
            if (!elem.isLeaf()) continue;
            if (elem.isNegated()) {
                this.negatives.add(elem);
                continue;
            }
            this.positives.add(elem);
        }
    }

    private void reHeapPriorityQueue(BooleanLogicTreeNode node) {
        this.positives.clear();
        Enumeration<javax.swing.tree.TreeNode> dfe = node.depthFirstEnumeration();
        while (dfe.hasMoreElements()) {
            BooleanLogicTreeNode elem = (BooleanLogicTreeNode)dfe.nextElement();
            if (!elem.isLeaf() || elem.isNegated()) continue;
            this.positives.add(elem);
        }
    }

    public boolean hasTop() {
        return this.topKey != null;
    }

    public Key getTopKey() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTopKey: " + this.topKey));
        }
        return this.topKey;
    }

    private void setTopKey(Key key) {
        if (this.overallRange != null && key != null && this.overallRange.getEndKey() != null && !this.overallRange.contains(key)) {
            this.topKey = null;
            return;
        }
        this.topKey = key;
    }

    public Value getTopValue() {
        if (this.topValue == null) {
            this.topValue = new Value(new byte[0]);
        }
        return this.topValue;
    }

    private void resetNegatives() {
        for (BooleanLogicTreeNode neg : this.negatives) {
            neg.setTopKey(null);
            neg.setValid(true);
        }
    }

    private String getEventKeyUid(Key k) {
        try {
            boolean idx = false;
            String sKey = k.getColumnFamily().toString();
            return sKey;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getIndexKeyUid(Key k) {
        try {
            boolean idx = false;
            String sKey = k.getColumnQualifier().toString();
            return sKey;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Key getOptimizedAdvanceKey() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getOptimizedAdvanceKey() called");
        }
        Enumeration<javax.swing.tree.TreeNode> bfe = this.root.breadthFirstEnumeration();
        ArrayList<BooleanLogicTreeNode> bfl = new ArrayList<BooleanLogicTreeNode>();
        while (bfe.hasMoreElements()) {
            BooleanLogicTreeNode node = (BooleanLogicTreeNode)bfe.nextElement();
            if (node.isNegated()) continue;
            node.setAdvanceKey(node.getTopKey());
            node.setDone(false);
            bfl.add(node);
        }
        int i = bfl.size() - 1;
        while (i >= 0) {
            if (((BooleanLogicTreeNode)bfl.get(i)).isLeaf() || ((BooleanLogicTreeNode)bfl.get(i)).isNegated()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("leaf, isDone?: " + ((BooleanLogicTreeNode)bfl.get(i)).isDone()));
                }
            } else {
                boolean firstTime;
                Enumeration<javax.swing.tree.TreeNode> children;
                BooleanLogicTreeNode node = (BooleanLogicTreeNode)bfl.get(i);
                node.setDone(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("for loop, node: " + node + " isDone? " + node.isDone()));
                }
                if (node.getType() == 10) {
                    BooleanLogicTreeNode max = null;
                    children = node.children();
                    firstTime = true;
                    while (children.hasMoreElements()) {
                        BooleanLogicTreeNode child = (BooleanLogicTreeNode)children.nextElement();
                        if (child.isNegated() || child.isChildrenAllNegated()) continue;
                        if (child.getAdvanceKey() == null) {
                            log.debug((Object)("\tchild does not advance key: " + child.printNode()));
                            node.setDone(true);
                            break;
                        }
                        log.debug((Object)("\tchild advanceKey: " + child.getAdvanceKey()));
                        if (firstTime) {
                            firstTime = false;
                            max = child;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("\tAND block, first valid child: " + child));
                            continue;
                        }
                        log.debug((Object)("\tAND block, max: " + max));
                        log.debug((Object)("\tAND block, child: " + child));
                        if (max.getAdvanceKey().getRow().compareTo((BinaryComparable)child.getAdvanceKey().getRow()) < 0) {
                            max = child;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"\tAND block, child row greater, new max.");
                            continue;
                        }
                        String uid_max = this.getEventKeyUid(max.getAdvanceKey());
                        String uid_child = this.getEventKeyUid(child.getAdvanceKey());
                        if (log.isDebugEnabled()) {
                            if (uid_max == null) {
                                log.debug((Object)"\tuid_max is currently null");
                            } else {
                                log.debug((Object)("\tuid_max: " + uid_max));
                            }
                            if (uid_child == null) {
                                log.debug((Object)"\tuid_child is null");
                            } else {
                                log.debug((Object)("\tuid_child: " + uid_child));
                            }
                        }
                        if (uid_max != null && uid_child != null) {
                            if (uid_max.compareTo(uid_child) >= 0) continue;
                            max = child;
                            continue;
                        }
                        if (uid_child == null) {
                            max = child;
                            log.debug((Object)"uid_child is null, we need to grab the next row.");
                            break;
                        }
                        log.debug((Object)("max is null and child is not, who should we keep? child: " + child));
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("attemptOptimization: AND with children, max: " + max));
                    }
                    if (max != null) {
                        node.setAdvanceKey(max.getAdvanceKey());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"AND block finished, max is null");
                        }
                        node.setDone(true);
                    }
                } else if (node.getType() == 9) {
                    BooleanLogicTreeNode min = null;
                    children = node.children();
                    firstTime = true;
                    int numChildren = node.getChildCount();
                    int allChildrenDone = 0;
                    while (children.hasMoreElements()) {
                        BooleanLogicTreeNode child = (BooleanLogicTreeNode)children.nextElement();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\tOR block start, child: " + child));
                        }
                        if (child.isNegated() || child.isChildrenAllNegated()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\tskip negated child: " + child));
                            }
                            --numChildren;
                            continue;
                        }
                        if (child.isDone()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\tchild is done: " + child));
                            }
                            if (numChildren == ++allChildrenDone) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"\tnumChildren==allChildrenDone, setDone & break");
                                }
                                node.setDone(true);
                                break;
                            }
                        }
                        if (child.getAdvanceKey() == null) {
                            log.debug((Object)"\tOR child doesn't have top or an AdvanceKey");
                            continue;
                        }
                        if (firstTime) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\tOR block, first valid node, min=child: " + child + "  advanceKey: " + child.getAdvanceKey()));
                            }
                            firstTime = false;
                            min = child;
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\tOR block, min: " + min));
                            log.debug((Object)("\tOR block, child: " + child));
                        }
                        if (min.getAdvanceKey().getRow().toString().compareTo(child.getAdvanceKey().getRow().toString()) > 0) {
                            min = child;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("\tmin row was greater than child, min=child: " + min));
                            continue;
                        }
                        if (min.getAdvanceKey().getRow().compareTo((BinaryComparable)child.getAdvanceKey().getRow()) < 0) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("\tmin row less than childs, keep min: " + min));
                            continue;
                        }
                        String uid_min = this.getEventKeyUid(min.getAdvanceKey());
                        String uid_child = this.getEventKeyUid(child.getAdvanceKey());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\ttesting uids, uid_min: " + uid_min + "  uid_child: " + uid_child));
                        }
                        if (uid_min != null && uid_child != null) {
                            if (uid_min.compareTo(uid_child) <= 0) continue;
                            min = child;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("\tuid_min > uid_child, set min to child: " + min));
                            continue;
                        }
                        if (uid_min != null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\tuid_min is null, take childs: " + uid_child));
                        }
                        min = child;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("attemptOptimization: OR with children, min: " + min));
                    }
                    if (min != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("OR block, min != null, advanceKey? " + min.getAdvanceKey()));
                        }
                        node.setAdvanceKey(min.getAdvanceKey());
                    } else {
                        log.debug((Object)("OR block, min is null..." + min));
                        node.setAdvanceKey(null);
                        node.setDone(true);
                    }
                } else if (node.getType() == 0) {
                    BooleanLogicTreeNode child;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"getOptimizedAdvanceKey, HEAD node");
                    }
                    if ((child = (BooleanLogicTreeNode)node.getFirstChild()).isDone()) {
                        Key k;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Head node's child is done, need to move to the next row");
                        }
                        if ((k = child.getAdvanceKey()) == null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"HEAD node, advance key is null, try to grab next row from topKey");
                            }
                            if (!this.hasTop()) return null;
                            k = this.getTopKey();
                            child.setAdvanceKey(new Key(new Text(k.getRow().toString() + "\u0001")));
                        } else {
                            Text row = new Text(k.getRow().toString() + "\u0001");
                            k = new Key(row);
                            child.setAdvanceKey(k);
                        }
                    }
                    if (!log.isDebugEnabled()) return new Key(child.getAdvanceKey().getRow(), child.getAdvanceKey().getColumnFamily(), child.getAdvanceKey().getColumnFamily());
                    log.debug((Object)("advance Key: " + child.getAdvanceKey()));
                    return new Key(child.getAdvanceKey().getRow(), child.getAdvanceKey().getColumnFamily(), child.getAdvanceKey().getColumnFamily());
                }
            }
            --i;
        }
        return null;
    }

    private boolean jump(Key jumpKey) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"JUMP!");
        }
        Enumeration<javax.swing.tree.TreeNode> bfe = this.root.breadthFirstEnumeration();
        while (bfe.hasMoreElements()) {
            BooleanLogicTreeNode n = (BooleanLogicTreeNode)bfe.nextElement();
            n.setAdvanceKey(null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("jump, All leaves need to advance to: " + jumpKey));
        }
        String advanceUid = this.getIndexKeyUid(jumpKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("advanceUid =>  " + advanceUid));
        }
        boolean ok = true;
        for (BooleanLogicTreeNode leaf : this.positives) {
            leaf.jump(jumpKey);
        }
        return ok;
    }

    public void next() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"next() method called");
        }
        boolean finished = false;
        boolean ok = true;
        if (this.positives.isEmpty()) {
            this.setTopKey(null);
            return;
        }
        Key previousJumpKey = null;
        while (!finished) {
            BooleanLogicTreeNode node;
            Key jumpKey = this.getOptimizedAdvanceKey();
            if (jumpKey == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"next(), jump key is null, stopping");
                }
                this.setTopKey(null);
                return;
            }
            if (log.isDebugEnabled()) {
                if (jumpKey != null) {
                    log.debug((Object)("next(), jumpKey: " + jumpKey));
                } else {
                    log.debug((Object)"jumpKey is null");
                }
            }
            boolean same = false;
            if (jumpKey != null && this.topKey != null) {
                same = this.getIndexKeyUid(jumpKey).equals(this.getEventKeyUid(this.topKey));
                log.debug((Object)("jumpKeyUid: " + this.getIndexKeyUid(jumpKey) + "  topKeyUid: " + this.getEventKeyUid(this.topKey)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("previousJumpKey: " + previousJumpKey));
                log.debug((Object)("current JumpKey: " + jumpKey));
            }
            if (jumpKey != null && !this.overallRange.contains(jumpKey)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"jumpKey is outside of range, that means the next key is out of range, stopping");
                    log.debug((Object)("jumpKey: " + jumpKey + " overallRange.endKey: " + this.overallRange.getEndKey()));
                }
                this.setTopKey(null);
                return;
            }
            boolean previousSame = false;
            if (previousJumpKey != null && jumpKey != null) {
                previousSame = previousJumpKey.equals((Object)jumpKey);
            }
            if (jumpKey != null && !same && !previousSame && ok) {
                previousJumpKey = jumpKey;
                ok = this.jump(jumpKey);
                if (!this.testTreeState()) continue;
                Key tempKey = this.root.getTopKey();
                if (!this.negatives.isEmpty()) {
                    this.advanceNegatives(this.root.getTopKey());
                    if (!this.testTreeState()) continue;
                }
                if (!this.root.getTopKey().equals((Object)tempKey)) continue;
                if (log.isDebugEnabled()) {
                    if (this.root.hasTop()) {
                        log.debug((Object)("this.root.getTopKey()->" + this.root.getTopKey()));
                    } else {
                        log.debug((Object)"next, this.root.getTopKey() is null");
                    }
                    if (this.topKey != null) {
                        log.debug((Object)("topKey->" + this.topKey));
                    } else {
                        log.debug((Object)"topKey is null");
                    }
                }
                if (this.compare(this.topKey, this.root.getTopKey()) == 0) continue;
                this.setTopKey(this.root.getTopKey());
                return;
            }
            this.reHeapPriorityQueue(this.root);
            while ((node = this.positives.poll()).isDone() || !node.hasTop()) {
                if (!this.positives.isEmpty()) continue;
                this.setTopKey(null);
                return;
            }
            if (log.isDebugEnabled()) {
                if (jumpKey == null) {
                    log.debug((Object)"no jump, jumpKey is null");
                } else if (this.topKey == null) {
                    log.debug((Object)("no jump, jumpKey: " + jumpKey + "  topKey: null"));
                } else {
                    log.debug((Object)("no jump, jumpKey: " + jumpKey + "  topKey: " + this.topKey));
                }
                log.debug((Object)("next, (no jump) min node: " + node));
                log.debug((Object)node);
            }
            node.next();
            this.resetNegatives();
            if (!node.hasTop()) {
                node.setValid(false);
                if (this.testTreeState() && this.topKey.compareTo(this.root.getTopKey()) != 0) {
                    if (this.overallRange != null) {
                        if (this.overallRange.contains(this.root.getTopKey())) {
                            this.setTopKey(this.root.getTopKey());
                            return;
                        }
                        this.setTopKey(null);
                        finished = true;
                        return;
                    }
                    this.setTopKey(this.root.getTopKey());
                    return;
                }
            } else {
                if (this.overallRange.contains(node.getTopKey())) {
                    this.positives.add(node);
                }
                if (this.testTreeState()) {
                    Key tempKey = this.root.getTopKey();
                    if (!this.negatives.isEmpty()) {
                        this.advanceNegatives(this.root.getTopKey());
                        if (!this.testTreeState()) continue;
                    }
                    if (this.root.getTopKey().equals((Object)tempKey)) {
                        if (log.isDebugEnabled()) {
                            if (this.root.hasTop()) {
                                log.debug((Object)("this.root.getTopKey()->" + this.root.getTopKey()));
                            } else {
                                log.debug((Object)"next, this.root.getTopKey() is null");
                            }
                            if (this.topKey != null) {
                                log.debug((Object)("topKey->" + this.topKey));
                            } else {
                                log.debug((Object)"topKey is null");
                            }
                        }
                        if (this.compare(this.topKey, this.root.getTopKey()) != 0) {
                            if (this.overallRange != null) {
                                if (this.overallRange.contains(this.root.getTopKey())) {
                                    this.setTopKey(this.root.getTopKey());
                                    return;
                                }
                                this.topKey = null;
                                finished = true;
                                return;
                            }
                            this.setTopKey(this.root.getTopKey());
                            return;
                        }
                    }
                }
            }
            if (!this.positives.isEmpty()) continue;
            finished = true;
            this.topKey = null;
        }
    }

    private void advanceNegatives(Key k) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("advancingNegatives for Key: " + k));
        }
        Text rowID = k.getRow();
        Text colFam = k.getColumnFamily();
        for (BooleanLogicTreeNode neg : this.negatives) {
            Key startKey = new Key(rowID, neg.getFieldName(), new Text(neg.getFieldValue() + "\u0000" + colFam));
            Key endKey = new Key(rowID, neg.getFieldName(), new Text(neg.getFieldValue() + "\u0000" + colFam + "\u0001"));
            Range range = new Range(startKey, true, endKey, false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("range: " + range));
            }
            neg.seek(range, EMPTY_COL_FAMS, false);
            if (neg.hasTop()) {
                neg.setValid(false);
            }
            if (!log.isDebugEnabled()) continue;
            if (neg.hasTop()) {
                log.debug((Object)("neg top key: " + neg.getTopKey()));
                continue;
            }
            log.debug((Object)"neg has no top");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (this.initfailed) return;
        this.overallRange = range;
        if (log.isDebugEnabled()) {
            log.debug((Object)("seek, overallRange: " + this.overallRange));
        }
        this.topKey = null;
        this.root.setTopKey(null);
        this.setupRangerators(range);
        this.reHeapPriorityQueue(this.root);
        for (BooleanLogicTreeNode node : this.positives) {
            node.setDone(false);
            node.seek(range, columnFamilies, inclusive);
            if (!log.isDebugEnabled()) continue;
            String tk = "empty";
            if (node.hasTop()) {
                tk = node.getTopKey().toString();
            }
            log.debug((Object)("leaf: " + node.getContents() + " topKey: " + tk));
        }
        this.splitLeaves(this.root);
        this.resetNegatives();
        if (this.testTreeState() && this.overallRange.contains(this.root.getTopKey())) {
            if (!this.negatives.isEmpty()) {
                this.advanceNegatives(this.root.getTopKey());
                if (!this.testTreeState()) {
                    this.next();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("overallRange " + this.overallRange + " topKey " + this.root.getTopKey() + " contains " + this.overallRange.contains(this.root.getTopKey())));
            }
            if (this.root.isValid() && this.overallRange.contains(this.root.getTopKey())) {
                this.setTopKey(this.root.getTopKey());
                return;
            }
            this.setTopKey(null);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"seek, testTreeState is false, HEAD(root) does not have top");
        }
        ArrayList<BooleanLogicTreeNode> removals = new ArrayList<BooleanLogicTreeNode>();
        for (BooleanLogicTreeNode node : this.positives) {
            if (node.hasTop() && this.overallRange.contains(node.getTopKey())) continue;
            removals.add(node);
        }
        Iterator<BooleanLogicTreeNode> i$ = removals.iterator();
        while (true) {
            BooleanLogicTreeNode node;
            if (!i$.hasNext()) {
                this.next();
                return;
            }
            node = i$.next();
            this.positives.remove(node);
        }
    }

    private int compare(Key k1, Key k2) {
        if (k1 != null && k2 != null) {
            return k1.compareTo(k2);
        }
        if (k1 == null && k2 == null) {
            return 0;
        }
        if (k1 == null) {
            return 1;
        }
        return -1;
    }

    private void setupRangerators(Range range) throws IOException {
        if (this.rangerators == null || this.rangerators.isEmpty()) {
            return;
        }
        for (BooleanLogicTreeNode node : this.rangerators) {
            HashSet<String> fValues = new HashSet<String>();
            OrIterator orIter = new OrIterator();
            SortedKeyValueIterator siter = this.sourceIterator.deepCopy(env);
            UniqFieldNameValueIterator uniq = new UniqFieldNameValueIterator(node.getFieldName(), node.getLowerBound(), node.getUpperBound());
            uniq.setSource((SortedKeyValueIterator<Key, Value>)siter);
            uniq.seek(range, EMPTY_COL_FAMS, false);
            while (uniq.hasTop()) {
                Key k = uniq.getTopKey();
                this.keyParser.parse(k);
                String val = this.keyParser.getFieldValue();
                if (!fValues.contains(val)) {
                    fValues.add(val);
                    orIter.addTerm((SortedKeyValueIterator<Key, Value>)siter, node.getFieldName(), new Text(val), env);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("setupRangerators, adding to OR:  " + node.getFieldName() + ":" + val));
                    }
                } else {
                    log.debug((Object)("already have this one: " + val));
                }
                uniq.next();
            }
            node.setUserObject(orIter);
        }
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        return new OptionDescriber.IteratorOptions(this.getClass().getSimpleName(), "evaluates event objects against an expression", Collections.singletonMap(QUERY_OPTION, "criteria expression"), null);
    }

    public boolean validateOptions(Map<String, String> options) {
        if (!options.containsKey(QUERY_OPTION)) {
            return false;
        }
        if (!options.containsKey(FIELD_INDEX_QUERY)) {
            return false;
        }
        this.updatedQuery = options.get(FIELD_INDEX_QUERY);
        return true;
    }

    public class BooleanLogicTreeNodeComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            BooleanLogicTreeNode n1 = (BooleanLogicTreeNode)o1;
            BooleanLogicTreeNode n2 = (BooleanLogicTreeNode)o2;
            Key k1 = n1.getTopKey();
            Key k2 = n2.getTopKey();
            if (log.isDebugEnabled()) {
                String t1 = "null";
                String t2 = "null";
                if (k1 != null) {
                    t1 = k1.getRow().toString() + "\u0000" + k1.getColumnFamily().toString();
                }
                if (k2 != null) {
                    t2 = k2.getRow().toString() + "\u0000" + k2.getColumnFamily().toString();
                }
                log.debug((Object)("BooleanLogicTreeNodeComparator   \tt1: " + t1 + "  t2: " + t2));
            }
            if (k1 != null && k2 != null) {
                return k1.compareTo(k2);
            }
            if (k1 == null && k2 == null) {
                return 0;
            }
            if (k1 == null) {
                return 1;
            }
            return -1;
        }
    }
}

