/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.iterators.AbstractEvaluatingIterator;
import org.calrissian.accumulorecipes.commons.iterators.support.EventFields;

public class EvaluatingIterator
extends AbstractEvaluatingIterator {
    LRUMap visibilityMap = new LRUMap();

    public EvaluatingIterator() {
    }

    public EvaluatingIterator(AbstractEvaluatingIterator other, IteratorEnvironment env) {
        super(other, env);
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new EvaluatingIterator(this, env);
    }

    @Override
    public PartialKey getKeyComparator() {
        return PartialKey.ROW_COLFAM;
    }

    @Override
    public Key getReturnKey(Key k) {
        Key r = new Key(k.getRowData().getBackingArray(), k.getColumnFamilyData().getBackingArray(), EMPTY_BYTE, k.getColumnVisibility().getBytes(), k.getTimestamp(), k.isDeleted(), false);
        return r;
    }

    @Override
    public void fillMap(EventFields event, Key key, Value value) {
        String colq = key.getColumnQualifier().toString();
        int idx = colq.indexOf("\u0000");
        String fieldName = colq.substring(0, idx);
        String fieldValue = colq.substring(idx + 1);
        event.put(fieldName, new EventFields.FieldValue(this.getColumnVisibility(key), fieldValue.getBytes(), value.get()));
    }

    public ColumnVisibility getColumnVisibility(Key key) {
        ColumnVisibility result = (ColumnVisibility)this.visibilityMap.get((Object)key.getColumnVisibility());
        if (result != null) {
            return result;
        }
        result = new ColumnVisibility(key.getColumnVisibility().getBytes());
        this.visibilityMap.put((Object)key.getColumnVisibility(), (Object)result);
        return result;
    }

    @Override
    public boolean isKeyAccepted(Key key) throws IOException {
        if (key.getColumnFamily().toString().startsWith("fi")) {
            Key copy = new Key(key.getRow(), new Text("fi\u0001"));
            List columnFamilies = Collections.emptyList();
            this.iterator.seek(new Range(copy, copy), columnFamilies, true);
            if (this.iterator.hasTop()) {
                return this.isKeyAccepted((Key)this.iterator.getTopKey());
            }
            return true;
        }
        return true;
    }
}

