/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.lang.StringUtils;

public class EventFieldsFilteringIterator
extends Filter {
    protected static final String SELECT_FIELDS = "selectFields";
    private Set<String> selectFields;

    public static void setSelectFields(IteratorSetting is, Set<String> selectFields) {
        is.addOption(SELECT_FIELDS, StringUtils.join(selectFields, (String)"\u0000"));
    }

    public boolean accept(Key k, Value v) {
        if (!k.getColumnFamily().toString().startsWith("fi")) {
            int ifx = k.getColumnQualifier().toString().indexOf("\u0000");
            String key = k.getColumnQualifier().toString().substring(0, ifx);
            return this.selectFields.contains(key);
        }
        return true;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (options == null) {
            throw new IllegalArgumentException("selectFields must be set for " + EventFieldsFilteringIterator.class.getName());
        }
        String eventFieldsOpt = options.get(SELECT_FIELDS);
        if (eventFieldsOpt == null) {
            throw new IllegalArgumentException("selectFields must be set for " + EventFieldsFilteringIterator.class.getName());
        }
        this.selectFields = new HashSet<String>(Arrays.asList(StringUtils.splitPreserveAllTokens((String)eventFieldsOpt, (String)"\u0000")));
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        EventFieldsFilteringIterator copy = (EventFieldsFilteringIterator)super.deepCopy(env);
        copy.selectFields = this.selectFields;
        return copy;
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.addNamedOption(SELECT_FIELDS, "fields to allow through (delimited by \u0000)");
        io.setDescription("EventFieldsFIlteringIterator only allows fields through that have a key existing in a given selection set");
        return io;
    }

    public boolean validateOptions(Map<String, String> options) {
        super.validateOptions(options);
        return options.containsKey(SELECT_FIELDS);
    }
}

