/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.support.FieldIndexKeyParser;
import org.calrissian.accumulorecipes.commons.iterators.support.QueryFunctions;

public class FieldIndexIterator
extends WrappingIterator {
    protected static final Logger log = Logger.getLogger(FieldIndexIterator.class);
    private static final Collection<ByteSequence> EMPTY_COL_FAMS = new ArrayList<ByteSequence>();
    private static JexlEngine engine = new JexlEngine();
    private Key topKey = null;
    private Value topValue = null;
    private Range range = null;
    private Text currentRow;
    private Text fName = null;
    private String fNameString = null;
    private Text fValue = null;
    private String fOperator = null;
    private Expression expr = null;
    private boolean negated = false;
    private int type;
    private Range parentRange;
    private Text parentEndRow = null;
    private FieldIndexKeyParser keyParser;

    public FieldIndexIterator() {
    }

    public FieldIndexIterator(int type, Text rowId, Text fieldName, Text fieldValue, String operator) {
        this.fName = fieldName;
        this.fNameString = this.fName.toString().substring(3);
        this.fValue = fieldValue;
        this.fOperator = operator;
        this.range = this.buildRange(rowId);
        this.negated = false;
        this.type = type;
        StringBuilder buf = new StringBuilder();
        buf.append(this.fNameString).append(" ").append(this.fOperator).append(" ").append("'").append(this.fValue.toString()).append("'");
        this.expr = engine.createExpression(buf.toString());
        this.keyParser = this.createDefaultKeyParser();
    }

    public FieldIndexIterator(int type, Text rowId, Text fieldName, Text fieldValue, boolean neg, String operator) {
        this.fName = fieldName;
        this.fNameString = this.fName.toString().substring(3);
        this.fValue = fieldValue;
        this.fOperator = operator;
        this.range = this.buildRange(rowId);
        this.negated = neg;
        this.type = type;
        StringBuilder buf = new StringBuilder();
        buf.append(this.fNameString).append(" ").append(this.fOperator).append(" ").append("'").append(this.fValue.toString()).append("'");
        this.expr = engine.createExpression(buf.toString());
        this.keyParser = this.createDefaultKeyParser();
    }

    public FieldIndexIterator(FieldIndexIterator other, IteratorEnvironment env) {
        this.setSource(other.getSource().deepCopy(env));
        this.keyParser = this.createDefaultKeyParser();
    }

    public static void setLogLevel(Level l) {
        log.setLevel(l);
    }

    private FieldIndexKeyParser createDefaultKeyParser() {
        FieldIndexKeyParser parser = new FieldIndexKeyParser();
        return parser;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new FieldIndexIterator(this, env);
    }

    public Key getTopKey() {
        return this.topKey;
    }

    private void setTopKey(Key key) {
        this.topKey = key;
    }

    public Value getTopValue() {
        return this.topValue;
    }

    private void setTopValue(Value v) {
        this.topValue = v;
    }

    public boolean hasTop() {
        return this.topKey != null;
    }

    public void next() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"next()");
        }
        if (this.hasTop()) {
            this.currentRow = this.topKey.getRow();
        }
        this.getSource().next();
        while (true) {
            log.debug((Object)("next(), Range: " + this.range));
            if (!this.getSource().hasTop()) break;
            Key k = (Key)this.getSource().getTopKey();
            if (this.range.contains(k)) {
                if (this.matches(k)) {
                    this.topKey = k;
                    this.topValue = (Value)this.getSource().getTopValue();
                    return;
                }
                this.getSource().next();
                continue;
            }
            if (this.parentEndRow != null) {
                if (k.getRow().equals((Object)this.currentRow)) {
                    this.currentRow = this.getNextRow();
                } else if (this.currentRow == null || k.getRow().compareTo((BinaryComparable)this.currentRow) > 0) {
                    this.currentRow = k.getRow();
                }
                if (this.currentRow == null || this.parentEndRow.compareTo((BinaryComparable)this.currentRow) < 0) {
                    this.topKey = null;
                    this.topValue = null;
                    return;
                }
            } else if (k.getRow().equals((Object)this.currentRow)) {
                this.currentRow = this.getNextRow();
                if (this.currentRow == null) {
                    this.topKey = null;
                    this.topValue = null;
                    return;
                }
            } else if (this.currentRow == null || k.getRow().compareTo((BinaryComparable)this.currentRow) > 0) {
                this.currentRow = k.getRow();
            }
            this.range = this.buildRange(this.currentRow);
            if (log.isDebugEnabled()) {
                log.debug((Object)("next, range: " + this.range));
            }
            this.getSource().seek(this.range, EMPTY_COL_FAMS, false);
        }
        this.topKey = null;
        this.topValue = null;
    }

    public void seek(Range r, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.parentRange = r;
        if (log.isDebugEnabled()) {
            log.debug((Object)("begin seek, range: " + r));
        }
        if (this.parentRange.getEndKey() != null && this.parentRange.getEndKey().getRow() != null) {
            this.parentEndRow = this.parentRange.getEndKey().getRow();
            if (log.isDebugEnabled()) {
                log.debug((Object)("begin seek, parentEndRow: " + this.parentEndRow));
            }
        }
        try {
            if (this.isNegated()) {
                this.range = r;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"seek, negation, skipping range modification.");
                }
            } else if (r.getStartKey() != null) {
                this.currentRow = r.getStartKey().getRow() == null || r.getStartKey().getRow().toString().isEmpty() ? this.getFirstRow() : r.getStartKey().getRow();
                this.range = this.buildRange(this.currentRow);
            } else {
                this.currentRow = this.getFirstRow();
                this.range = this.buildRange(this.currentRow);
            }
            this.setTopKey(null);
            this.setTopValue(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("seek, incoming range: " + this.range));
            }
            this.getSource().seek(this.range, columnFamilies, inclusive);
            while (this.topKey == null) {
                if (this.getSource().hasTop()) {
                    Key k;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("seek, source has top: " + this.getSource().getTopKey()));
                    }
                    if (this.range.contains(k = (Key)this.getSource().getTopKey())) {
                        if (this.matches(k)) {
                            this.topKey = k;
                            this.topValue = (Value)this.getSource().getTopValue();
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"seek, source has top in valid range");
                            continue;
                        }
                        this.getSource().next();
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"seek, top out of range");
                        String pEndRow = "empty";
                        if (this.parentEndRow != null) {
                            pEndRow = this.parentEndRow.toString();
                        }
                        log.debug((Object)("source.topKey.row: " + k.getRow() + "\t currentRow: " + this.currentRow + "\t parentEndRow: " + pEndRow));
                    }
                    if (this.isNegated()) {
                        this.topKey = null;
                        this.topValue = null;
                        return;
                    }
                    if (this.parentEndRow != null) {
                        if (k.getRow().equals((Object)this.currentRow)) {
                            this.currentRow = this.getNextRow();
                        }
                        if (this.currentRow == null || this.parentEndRow.compareTo((BinaryComparable)this.currentRow) < 0) {
                            this.topKey = null;
                            this.topValue = null;
                            return;
                        }
                    } else if (k.getRow().equals((Object)this.currentRow)) {
                        this.currentRow = this.getNextRow();
                        if (this.currentRow == null) {
                            this.topKey = null;
                            this.topValue = null;
                            return;
                        }
                    }
                    this.range = this.buildRange(this.currentRow);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("currentRow: " + this.currentRow));
                        log.debug((Object)("seek, range: " + this.range));
                    }
                    this.getSource().seek(this.range, columnFamilies, inclusive);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"seek, underlying source had no top key.");
                }
                this.topKey = null;
                this.topValue = null;
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("seek, topKey found: " + this.topKey));
            }
        }
        catch (IOException e) {
            this.topKey = null;
            this.topValue = null;
            throw new IOException();
        }
    }

    public boolean isNegated() {
        return this.negated;
    }

    public Text getCurrentRow() {
        return this.currentRow;
    }

    public Text getfName() {
        return this.fName;
    }

    public Text getfValue() {
        return this.fValue;
    }

    public boolean jump(Key jumpKey) throws IOException {
        int comp;
        if (log.isDebugEnabled()) {
            String pEndRow = "empty";
            if (this.parentEndRow != null) {
                pEndRow = this.parentEndRow.toString();
            }
            log.debug((Object)("jump, current range: " + this.range + "  parentEndRow is: " + pEndRow));
        }
        if (this.parentEndRow != null && jumpKey.getRow().compareTo((BinaryComparable)this.parentEndRow) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("jumpRow: " + jumpKey.getRow() + " is greater than my parentEndRow: " + this.parentEndRow));
            }
            return false;
        }
        if (!this.hasTop()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("current row: " + this.currentRow));
            }
            if (this.parentEndRow != null) {
                if (jumpKey.getRow().compareTo((BinaryComparable)this.parentEndRow) > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"jumpKey row is greater than my parentEndRow, done");
                    }
                    return false;
                }
                if (this.currentRow == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"I have parentEndRow, but no current row, must have hit end of tablet, done");
                    }
                    return false;
                }
                if (this.currentRow.compareTo((BinaryComparable)jumpKey.getRow()) >= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"I have parentEndRow, but topKey, and my currentRow is >= jumpRow, done");
                    }
                    return false;
                }
            } else {
                if (this.currentRow == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"no parentEndRow and current Row is null, must have hit end of tablet, done");
                    }
                    return false;
                }
                if (this.currentRow.compareTo((BinaryComparable)jumpKey.getRow()) >= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"no parentEndRow, no topKey, and currentRow is >= jumpRow, done");
                    }
                    return false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"no topKey, but jumpRow is ahead and I'm allowed to go to it, marking");
            }
            comp = -1;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"have top, can do normal comparisons");
            }
            comp = this.topKey.getRow().compareTo((BinaryComparable)jumpKey.getRow());
        }
        if (comp > 0) {
            if (this.canBeInNextRow()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"I'm ahead of jump row & it's ok.");
                    log.debug((Object)("jumpRow: " + jumpKey.getRow() + " myRow: " + this.topKey.getRow() + " parentEndRow: " + this.parentEndRow));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"I'm ahead of jump row & can't be here, or at end of tablet.");
            }
            this.topKey = null;
            this.topValue = null;
            return false;
        }
        if (comp < 0) {
            if (log.isDebugEnabled()) {
                String myRow = "";
                if (this.hasTop()) {
                    myRow = this.topKey.getRow().toString();
                } else if (this.currentRow != null) {
                    myRow = this.currentRow.toString();
                }
                log.debug((Object)("My row " + myRow + " is less than jump row: " + jumpKey.getRow() + " seeking"));
            }
            this.range = this.buildRange(jumpKey.getRow());
            boolean success = this.jumpSeek(this.range);
            if (log.isDebugEnabled() && success) {
                log.debug((Object)("uid forced jump, found topKey: " + this.topKey));
            }
            if (!this.hasTop()) {
                log.debug((Object)"seeked with new row and had no top");
                this.topKey = null;
                this.topValue = null;
                return false;
            }
            if (this.parentEndRow != null && this.currentRow.compareTo((BinaryComparable)this.parentEndRow) > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("myRow: " + this.getTopKey().getRow() + " is past parentEndRow: " + this.parentEndRow));
                }
                this.topKey = null;
                this.topValue = null;
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("jumped, valid top: " + this.getTopKey()));
            }
            return true;
        }
        this.keyParser.parse(this.topKey);
        String myUid = this.keyParser.getUid();
        this.keyParser.parse(jumpKey);
        String jumpUid = this.keyParser.getUid();
        int ucomp = myUid.compareTo(jumpUid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("topKeyUid: " + myUid + "  jumpUid: " + jumpUid + "  myUid.compareTo(jumpUid)->" + ucomp));
        }
        if (ucomp < 0) {
            log.debug((Object)("my uid is less than jumpUid, topUid: " + myUid + "   jumpUid: " + jumpUid));
            Text cq = jumpKey.getColumnQualifier();
            int index = cq.find("\u0000");
            if (0 > index) {
                log.error((Object)"Expected a NULL separator in the column qualifier");
                this.topKey = null;
                this.topValue = null;
                return false;
            }
            cq.set(cq.getBytes(), index + 1, cq.getLength() - index - 1);
            Key startKey = new Key(this.topKey.getRow(), this.fName, new Text(this.fValue + "\u0000" + cq));
            Key endKey = new Key(this.topKey.getRow(), this.fName, new Text(this.fValue + "\u0001"));
            this.range = new Range(startKey, true, endKey, false);
            log.debug((Object)("Using range: " + this.range + " to seek"));
            boolean success = this.jumpSeek(this.range);
            if (log.isDebugEnabled() && success) {
                log.debug((Object)("uid forced jump, found topKey: " + this.topKey));
            }
            return success;
        }
        log.debug((Object)("my uid is greater than jumpUid, topKey: " + this.topKey + "   jumpKey: " + jumpKey));
        log.debug((Object)"doing nothing");
        return this.hasTop();
    }

    private boolean canBeInNextRow() {
        if (this.parentEndRow == null) {
            return true;
        }
        if (this.currentRow == null) {
            return false;
        }
        return this.currentRow.compareTo((BinaryComparable)this.parentEndRow) <= 0;
    }

    private Range buildRange(Text rowId) {
        if (this.fOperator.equals(">")) {
            Key startKey = new Key(rowId, this.fName, new Text(this.fValue));
            Key endKey = new Key(rowId, new Text(this.fName + "\u0000"));
            return new Range(startKey, false, endKey, true);
        }
        if (this.fOperator.equals(">=")) {
            Key startKey = new Key(rowId, this.fName, new Text(this.fValue));
            Key endKey = new Key(rowId, new Text(this.fName + "\u0000"));
            return new Range(startKey, true, endKey, true);
        }
        if (this.fOperator.equals("<")) {
            Key startKey = new Key(rowId, this.fName);
            Key endKey = new Key(rowId, new Text(this.fName), new Text(this.fValue));
            return new Range(startKey, true, endKey, false);
        }
        if (this.fOperator.equals("<=")) {
            Key startKey = new Key(rowId, this.fName);
            Key endKey = new Key(rowId, new Text(this.fName), new Text(this.fValue + "\u0001"));
            return new Range(startKey, true, endKey, false);
        }
        Key startKey = new Key(rowId, this.fName, new Text(this.fValue + "\u0000"));
        Key endKey = new Key(rowId, this.fName, new Text(this.fValue + "\u0001"));
        return new Range(startKey, true, endKey, false);
    }

    private Text getNextRow() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getNextRow()");
        }
        Key fakeKey = new Key(new Text(this.currentRow + "\u0000"));
        Range fakeRange = new Range(fakeKey, fakeKey);
        this.getSource().seek(fakeRange, EMPTY_COL_FAMS, false);
        if (this.getSource().hasTop()) {
            return ((Key)this.getSource().getTopKey()).getRow();
        }
        return null;
    }

    private Text getFirstRow() throws IOException {
        this.getSource().seek(new Range(), EMPTY_COL_FAMS, false);
        if (this.getSource().hasTop()) {
            return ((Key)this.getSource().getTopKey()).getRow();
        }
        throw new IOException();
    }

    private boolean matches(Key k) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"You've reached the match function!");
        }
        MapContext ctx = new MapContext();
        this.keyParser.parse(k);
        String fieldValue = this.keyParser.getFieldValue();
        ctx.set(this.fNameString, (Object)fieldValue);
        Object o = this.expr.evaluate((JexlContext)ctx);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("matches:: fName: " + this.fName + " , fValue: " + fieldValue + " ,  operator: " + this.fOperator + " , key: " + k));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("NO MATCH:: fName: " + this.fName + " , fValue: " + fieldValue + " ,  operator: " + this.fOperator + " , key: " + k));
        }
        return false;
    }

    private boolean jumpSeek(Range r) throws IOException {
        this.range = r;
        this.setTopKey(null);
        this.setTopValue(null);
        this.getSource().seek(this.range, EMPTY_COL_FAMS, false);
        while (this.topKey == null) {
            if (this.getSource().hasTop()) {
                Key k;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jump, source has top: " + this.getSource().getTopKey()));
                }
                if (this.range.contains(k = (Key)this.getSource().getTopKey())) {
                    if (this.matches(k)) {
                        this.topKey = k;
                        this.topValue = (Value)this.getSource().getTopValue();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"jump, source has top in valid range");
                        continue;
                    }
                    this.getSource().next();
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"jump, top out of range");
                    String pEndRow = "empty";
                    if (this.parentEndRow != null) {
                        pEndRow = this.parentEndRow.toString();
                    }
                    log.debug((Object)("source.topKey.row: " + k.getRow() + "\t currentRow: " + this.currentRow + "\t parentEndRow: " + pEndRow));
                }
                if (this.parentEndRow != null) {
                    if (this.currentRow == null) {
                        this.topKey = null;
                        this.topValue = null;
                        return false;
                    }
                    if (k.getRow().equals((Object)this.currentRow)) {
                        this.currentRow = this.getNextRow();
                    } else if (k.getRow().compareTo((BinaryComparable)this.currentRow) > 0) {
                        this.currentRow = k.getRow();
                    }
                    if (this.currentRow == null || this.parentEndRow.compareTo((BinaryComparable)this.currentRow) < 0) {
                        this.topKey = null;
                        this.topValue = null;
                        return false;
                    }
                } else {
                    if (this.currentRow == null || k.getRow() == null) {
                        this.topKey = null;
                        this.topValue = null;
                        return false;
                    }
                    if (k.getRow().equals((Object)this.currentRow)) {
                        this.currentRow = this.getNextRow();
                        if (this.currentRow == null) {
                            this.topKey = null;
                            this.topValue = null;
                            return false;
                        }
                    } else if (k.getRow().compareTo((BinaryComparable)this.currentRow) > 0) {
                        this.currentRow = k.getRow();
                    }
                }
                this.range = this.buildRange(this.currentRow);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jump, new build range: " + this.range));
                }
                this.getSource().seek(this.range, EMPTY_COL_FAMS, false);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"jump, underlying source had no top key.");
            }
            this.topKey = null;
            this.topValue = null;
            return false;
        }
        return this.hasTop();
    }

    static {
        engine.setCache(128);
        HashMap<String, Class<QueryFunctions>> functions = new HashMap<String, Class<QueryFunctions>>();
        functions.put("f", QueryFunctions.class);
        engine.setFunctions(functions);
    }
}

