/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SkippingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;

public class FirstEntryInColumnIterator
extends SkippingIterator
implements OptionDescriber {
    static final String NUM_SCANS_STRING_NAME = "scansBeforeSeek";
    private Range latestRange;
    private Collection<ByteSequence> latestColumnFamilies;
    private boolean latestInclusive;
    private Text lastRowFound;
    private Text lastColFFound;
    private int numscans;
    private boolean finished = true;

    public static void setNumScansBeforeSeek(IteratorSetting cfg, int num) {
        cfg.addOption(NUM_SCANS_STRING_NAME, Integer.toString(num));
    }

    public FirstEntryInColumnIterator() {
    }

    public FirstEntryInColumnIterator(FirstEntryInColumnIterator other, IteratorEnvironment env) {
        this.setSource(other.getSource().deepCopy(env));
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new FirstEntryInColumnIterator(this, env);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        String o = options.get(NUM_SCANS_STRING_NAME);
        this.numscans = o == null ? 10 : Integer.parseInt(o);
    }

    protected void consume() throws IOException {
        if (this.finished || this.lastRowFound == null) {
            return;
        }
        int count = 0;
        while (this.getSource().hasTop() && this.lastRowFound.equals((Object)((Key)this.getSource().getTopKey()).getRow()) && this.lastColFFound.equals((Object)((Key)this.getSource().getTopKey()).getColumnFamily())) {
            if (count < this.numscans) {
                ++count;
                this.getSource().next();
                continue;
            }
            count = 0;
            Key nextKey = ((Key)this.getSource().getTopKey()).followingKey(PartialKey.ROW_COLFAM);
            if (!this.latestRange.afterEndKey(nextKey)) {
                this.getSource().seek(new Range(nextKey, true, this.latestRange.getEndKey(), this.latestRange.isEndKeyInclusive()), this.latestColumnFamilies, this.latestInclusive);
                continue;
            }
            this.finished = true;
            break;
        }
        this.lastRowFound = this.getSource().hasTop() ? ((Key)this.getSource().getTopKey()).getRow(this.lastRowFound) : null;
        this.lastColFFound = this.getSource().hasTop() ? ((Key)this.getSource().getTopKey()).getColumnFamily(this.lastColFFound) : null;
    }

    public boolean hasTop() {
        return !this.finished && this.getSource().hasTop();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.latestRange = range;
        this.latestColumnFamilies = columnFamilies;
        this.latestInclusive = inclusive;
        this.lastRowFound = null;
        this.lastColFFound = null;
        Key startKey = range.getStartKey();
        Range seekRange = new Range(startKey == null ? null : new Key(startKey.getRow(), startKey.getColumnFamily()), true, range.getEndKey(), range.isEndKeyInclusive());
        super.seek(seekRange, columnFamilies, inclusive);
        this.finished = false;
        if (this.getSource().hasTop()) {
            this.lastRowFound = ((Key)this.getSource().getTopKey()).getRow();
            this.lastColFFound = ((Key)this.getSource().getTopKey()).getColumnFamily();
            if (range.beforeStartKey((Key)this.getSource().getTopKey())) {
                this.consume();
            }
        }
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        String name = "firstEntryInColumn";
        String desc = "Only allows iteration over the first entry per column family";
        HashMap<String, String> namedOptions = new HashMap<String, String>();
        namedOptions.put(NUM_SCANS_STRING_NAME, "Number of scans to try before seeking [10]");
        return new OptionDescriber.IteratorOptions(name, desc, namedOptions, null);
    }

    public boolean validateOptions(Map<String, String> options) {
        try {
            String o = options.get(NUM_SCANS_STRING_NAME);
            if (o != null) {
                Integer.parseInt(o);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad integer scansBeforeSeek:" + options.get(NUM_SCANS_STRING_NAME), e);
        }
        return true;
    }
}

