/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.calrissian.accumulorecipes.commons.support.qfd.GlobalIndexValue;

public class GlobalIndexCombiner
extends Combiner {
    public Value reduce(Key key, Iterator<Value> valueIterator) {
        long cardinality = 0L;
        long expiration = 0L;
        while (valueIterator.hasNext()) {
            GlobalIndexValue value = new GlobalIndexValue(valueIterator.next());
            cardinality += value.getCardinatlity();
            if (value.getExpiration() == -1L) {
                expiration = -1L;
            }
            if (expiration == -1L) continue;
            expiration = Math.max(expiration, value.getExpiration());
        }
        return new GlobalIndexValue(cardinality, expiration).toValue();
    }
}

