/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.calrissian.accumulorecipes.commons.iterators.ExpirationFilter;
import org.calrissian.accumulorecipes.commons.support.metadata.MetadataSerDe;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.mango.io.Serializables;

public class MetadataExpirationFilter
extends ExpirationFilter {
    public static final String METADATA_SERDE = "metadataSerDe";
    private MetadataSerDe metadataSerDe;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        try {
            this.metadataSerDe = (MetadataSerDe)Serializables.fromBase64((byte[])options.get(METADATA_SERDE).getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        MetadataExpirationFilter copy = (MetadataExpirationFilter)super.deepCopy(env);
        copy.metadataSerDe = this.metadataSerDe;
        return copy;
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("metadataExpirationFilter");
        io.addNamedOption(METADATA_SERDE, "The metadata serializer/deserializer to use. This must match the SerDe that was use to encode the metadata");
        io.setDescription("MetadataExpirationFilter removes entries with timestamps more than <ttl> milliseconds old & timestamps newer than currentTime. ttl is determined by an expiration field in metadata encoded in the value");
        return io;
    }

    public boolean validateOptions(Map<String, String> options) {
        super.validateOptions(options);
        try {
            Serializables.fromBase64((byte[])options.get(METADATA_SERDE).getBytes());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void setMetadataSerde(IteratorSetting setting, MetadataSerDe metadataSerDe) {
        try {
            setting.addOption(METADATA_SERDE, new String(Serializables.toBase64((Serializable)metadataSerDe)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected long parseExpiration(Value v) {
        Map<String, Object> metadata = this.metadataSerDe.deserialize(v.get());
        if (metadata != null) {
            return Metadata.Expiration.getExpiration(metadata, -1L);
        }
        return -1L;
    }
}

