/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.commons.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.log4j.Logger;
import org.calrissian.accumulorecipes.commons.iterators.BooleanLogicIterator;
import org.calrissian.accumulorecipes.commons.iterators.EvaluatingIterator;
import org.calrissian.accumulorecipes.commons.iterators.ReadAheadIterator;

public class OptimizedQueryIterator
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    private static Logger log = Logger.getLogger(OptimizedQueryIterator.class);
    private EvaluatingIterator event = null;
    private SortedKeyValueIterator<Key, Value> index = null;
    private Key key = null;
    private Value value = null;
    private boolean eventSpecificRange = false;

    public OptimizedQueryIterator() {
    }

    public OptimizedQueryIterator(OptimizedQueryIterator other, IteratorEnvironment env) {
        this.event = other.event;
        this.index = other.index;
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("expr", "full criteria expression");
        options.put("FIELD_INDEX_QUERY", "modified criteria for the field index criteria portion");
        options.put("queue.size", "parallel queue size");
        options.put("timeout", "parallel iterator timeout");
        return new OptionDescriber.IteratorOptions(this.getClass().getSimpleName(), "evaluates event objects against an expression using the field index", options, null);
    }

    public boolean validateOptions(Map<String, String> options) {
        return options.containsKey("expr") && options.containsKey("FIELD_INDEX_QUERY");
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        if (!this.validateOptions(options)) {
            throw new IllegalArgumentException("Invalid options");
        }
        this.event = new EvaluatingIterator();
        this.event.init((SortedKeyValueIterator<Key, Value>)source.deepCopy(env), options, env);
        if (options.containsKey("queue.size") && options.containsKey("timeout")) {
            BooleanLogicIterator bli = new BooleanLogicIterator();
            bli.init(source, options, env);
            this.index = new ReadAheadIterator();
            this.index.init((SortedKeyValueIterator)bli, options, env);
        } else {
            this.index = new BooleanLogicIterator();
            this.index.init(source, options, env);
        }
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new OptimizedQueryIterator(this, env);
    }

    public Key getTopKey() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTopKey: " + this.key));
        }
        return this.key;
    }

    public Value getTopValue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTopValue: " + this.value));
        }
        return this.value;
    }

    public boolean hasTop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasTop: returned: " + (this.key != null)));
        }
        return this.key != null;
    }

    public void next() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"next");
        }
        if (this.key != null) {
            this.key = null;
            this.value = null;
        }
        if (this.eventSpecificRange) {
            this.event.next();
            if (this.event.hasTop()) {
                this.key = this.event.getTopKey();
                this.value = this.event.getTopValue();
            }
        } else {
            do {
                this.index.next();
                if (!this.index.hasTop()) continue;
                Key eventKey = (Key)this.index.getTopKey();
                Key endKey = eventKey.followingKey(PartialKey.ROW_COLFAM);
                Key startKey = new Key(eventKey.getRow(), eventKey.getColumnFamily());
                Range eventRange = new Range(startKey, endKey);
                HashSet<ByteSequence> cf = new HashSet<ByteSequence>();
                cf.add(eventKey.getColumnFamilyData());
                this.event.seek(eventRange, cf, true);
                if (!this.event.hasTop()) continue;
                this.key = this.event.getTopKey();
                this.value = this.event.getTopValue();
            } while (this.key == null && this.index.hasTop());
        }
        if (!(this.key == null && this.value == null || this.key != null && this.value != null)) {
            log.warn((Object)("Key: " + (this.key == null ? "null" : this.key.toString())));
            log.warn((Object)("Value: " + (this.value == null ? "null" : this.value.toString())));
            throw new IOException("Return values are inconsistent");
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("seek, range:" + range));
        }
        if (null != range.getEndKey() && range.getEndKey().getColumnFamily() != null && range.getEndKey().getColumnFamily().getLength() != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Jumping straight to the event");
            }
            this.eventSpecificRange = true;
            this.event.seek(range, columnFamilies, inclusive);
            if (this.event.hasTop()) {
                this.key = this.event.getTopKey();
                this.value = this.event.getTopValue();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using BooleanLogicIteratorJexl");
            }
            this.index.seek(range, columnFamilies, inclusive);
            if (this.index.hasTop()) {
                Key eventKey = (Key)this.index.getTopKey();
                Range eventRange = new Range(eventKey.getRow());
                HashSet<ByteSequence> cf = new HashSet<ByteSequence>();
                cf.add(eventKey.getColumnFamilyData());
                this.event.seek(eventRange, cf, true);
                if (this.event.hasTop()) {
                    this.key = this.event.getTopKey();
                    this.value = this.event.getTopValue();
                } else {
                    this.next();
                }
            }
        }
    }
}

